/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.profile.common;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.simantics.db.Resource;
import org.simantics.db.procedure.SetListener;
import org.simantics.scenegraph.profile.Group;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.Style;

public class ObserverGroupListener
implements SetListener<Resource> {
    final Map<Object, Object> items = new ConcurrentHashMap<Object, Object>();
    final Map<Resource, Resource> entries = new ConcurrentHashMap<Resource, Resource>();
    protected final Style style;
    protected final Group group;
    protected final Observer observer;
    private boolean disposed = false;

    public ObserverGroupListener(Style style, Group group, Observer observer) {
        assert (style != null);
        assert (group != null);
        assert (observer != null);
        this.style = style;
        this.group = group;
        this.observer = observer;
    }

    public void add(Resource item) {
        this.items.put(item, item);
        this.observer.update(this.style, item);
    }

    public void remove(Resource item) {
        this.items.remove(item);
        this.observer.update(this.style, item);
    }

    public int hashCode() {
        return this.observer.hashCode() + 31 * this.group.hashCode() + 41 * this.style.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ObserverGroupListener other = (ObserverGroupListener)object;
        return this.observer.equals(other.observer) && this.group.equals(other.group) && this.style.equals(other.style);
    }

    public Set<Object> getItems() {
        return this.items.keySet();
    }

    public void dispose() {
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed || this.observer.isDisposed();
    }

    public void exception(Throwable throwable) {
        this.observer.exception(throwable);
    }

    public void addEntry(Resource entry) {
        this.entries.put(entry, entry);
    }

    public void removeEntry(Resource entry) {
        this.entries.remove(entry);
    }

    public boolean hasEntries() {
        return !this.entries.isEmpty();
    }
}

