/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.profile.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scenegraph.profile.ProfileUtils;

/**
 * @author Tuukka Lehtonen
 */
public class ProfileEntryResources extends ResourceRead2<Collection<Resource>> {

    protected DiagramResource DIA;

    public ProfileEntryResources(Resource profile, Resource entry) {
        super(profile, entry);
    }

    protected boolean test(ReadGraph graph, Resource activeProfile, Resource entry) throws DatabaseException {
        return true;
    }

    public List<Resource> process(ReadGraph graph, Resource activeProfile, Resource item, List<Resource> result, HashSet<Resource> visited) throws DatabaseException {
    	List<Resource> entries = ProfileUtils.getProfileChildrenFromEntries(graph, item);
        for (Resource entry : entries) {
        	Resource children = graph.getPossibleObject(entry, DIA.HasEntries);
            if (children != null) {
                process(graph, activeProfile, children, result, visited);
            } else {
                if (test(graph, activeProfile, entry)) {
                    if (!visited.contains(entry)) {
                        result.add(entry);
                        visited.add(entry);
                    }
                }
            }
        }

        return result;
    }

    @Override
    public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
        this.DIA = DiagramResource.getInstance(graph);
        return process(graph, resource, resource2, new ArrayList<Resource>(), new HashSet<Resource>());
    }

}
