/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.profile.common;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import org.simantics.db.Resource;
import org.simantics.db.procedure.SetListener;
import org.simantics.scenegraph.profile.Group;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.Style;

public class ObserverGroupListener implements SetListener<Resource> {

    final Map<Object, Object> items = new ConcurrentHashMap<Object, Object>();
    final Map<Resource, Resource> entries = new ConcurrentHashMap<Resource, Resource>();

    protected final Style style;
    protected final Group group;
    protected final Observer observer;
    private boolean disposed = false;

    public ObserverGroupListener(Style style, Group group, Observer observer) {
        assert(style != null);
        assert(group != null);
        assert(observer != null);
        this.style = style;
        this.group = group;
        this.observer = observer;
    }

    @Override
    public void add(Resource item) {
        //System.out.println("Add to group(" + this + "): " + item);
        items.put(item, item);
        observer.update(style, item);
    }

    @Override
    public void remove(Resource item) {
//        new Exception().printStackTrace();
        //System.out.println("Remove from group(" + this + "): " + item);
        items.remove(item);
        observer.update(style, item);
    }

    @Override
    public int hashCode() {
        return observer.hashCode() + 31 * group.hashCode() + 41 * style.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        ObserverGroupListener other = (ObserverGroupListener)object;
        return observer.equals(other.observer) && group.equals(other.group) && style.equals(other.style);
    }

    public Set<Object> getItems() {
        return items.keySet();
    }

    public void dispose() {
        this.disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return disposed || observer.isDisposed();
    }

    @Override
    public void exception(Throwable throwable) {
        observer.exception(throwable);
    }

    public void addEntry(Resource entry) {
        entries.put(entry, entry);
    }

    public void removeEntry(Resource entry) {
        entries.remove(entry);
    }

    public boolean hasEntries() {
        return !entries.isEmpty();
    }

}
