package org.simantics.scenegraph.loader;

import org.osgi.framework.Bundle;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;

public class StandardScenegraphLoader implements ScenegraphLoader {

	final private Resource configuration;
	final private Class<?> clazz;
	
	public StandardScenegraphLoader(Resource configuration, Bundle bundle, String className) throws ClassNotFoundException {
		this.configuration = configuration;
		clazz = bundle.loadClass(className);
	}
	
	@Override
	public INode create(RequestProcessor processor, ScenegraphLoaderProcess process, ParentNode<?> parent, Variable context) throws DatabaseException {
		return ScenegraphLoaderUtils.create(processor, process, parent, configuration, context, clazz);
	}

}
