package org.simantics.project.management.install;

import java.io.IOException;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.provisional.p2.installer.InstallAdvisor;
import org.eclipse.equinox.internal.provisional.p2.installer.InstallDescription;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.core.UIServices;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.simantics.project.management.P2Util;
import org.simantics.project.management.TrustAllCertificates;

/**
 * P2 installer util.
 * 
 * Heavily inspired by org.eclipse.equinox.p2.installer project.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 */
public class InstallerUtil {

	private static final String SYS_PROP_INSTALL_DESCRIPTION = "org.eclipse.equinox.p2.installDescription";
	
	public static IStatus install(InstallAdvisor advisor, InstallDescription description, IProgressMonitor monitor) throws Exception {
		if (advisor == null)
			advisor = getDefaultAdvisor();
		if (description == null)
			description = getDefaultDescription(SubMonitor.convert(monitor));

		advisor.prepareInstallDescription(description);
		IProvisioningAgent agent = startAgent(description);		
		
		InstallUpdateProductOperation operation = new InstallUpdateProductOperation(agent, description);
		
		IStatus status = advisor.performInstall(operation);
		if (!status.isOK()) {
//			ShowMessage.showStatus(status);
		}
		advisor.setResult(status);
		advisor.stop();
		agent.stop();
		return status;
	}
	
	public static InstallDescription getDefaultDescription(SubMonitor monitor) throws Exception {
		String site = System.getProperty(SYS_PROP_INSTALL_DESCRIPTION);
		return InstallDescriptionParser.createDescription(site, monitor);
		
	}
	
	public static InstallAdvisor getDefaultAdvisor() {
		InstallAdvisor advisor = new DefaultInstallAdvisor();
		advisor.start();
		return advisor;
	}
	
	public static IProvisioningAgent startAgent(InstallDescription description) throws Exception {
		IPath installLocation = description.getInstallLocation();
		if (installLocation == null)
			throw new Exception("No install location");
		
		try {
			// Create recruiter
			IProvisioningAgentProvider provider = P2Util.getProvisioningAgentProvider();
			
			// Set agent location if specified. Contains P2 install data
			IPath agentLocation = description.getAgentLocation();
			
			// Recruit Agent - Permission to provision
			IProvisioningAgent agent = provider.createAgent(agentLocation == null ? null : agentLocation.toFile().toURI());
			
			// Omit "This bundle is not certified" dialog. 			
			UIServices serviceUI = new TrustAllCertificates();
			agent.registerService("org.eclipse.equinox.p2.core.UIServices", serviceUI);
			
			
			return agent;
		} catch (ProvisionException e) {
			throw new Exception("Cannot create agent", e);
		}
	}

	
	/**
	 * Copied from ServiceHelper because we need to obtain services
	 * before p2 has been started.
	 */
	public static Object getService(BundleContext context, String name) {
		if (context == null)
			return null;
		ServiceReference reference = context.getServiceReference(name);
		if (reference == null)
			return null;
		Object result = context.getService(reference);
		context.ungetService(reference);
		return result;
	}
	
	
	public static void launchProduct(InstallDescription description) throws Exception {
		IPath installLocation = description.getInstallLocation();
		IPath toRun = installLocation.append(description.getLauncherName());
		try {
			Runtime.getRuntime().exec(toRun.toString(), null, installLocation.toFile());
		} catch (IOException e) {
			throw new Exception("Lanuching an app failed", e);
		}

	}
}
