/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.platform.ui.internal;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.Appender;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.simantics.UnhandledExceptionService;
import org.simantics.platform.ui.SimanticsConsole;
import org.simantics.platform.ui.internal.ConsoleAppender;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractUIPlugin {
    private BundleContext context;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.context = context;
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(this::initConsole);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.context = null;
        super.stop(context);
    }

    private void initConsole() {
        if (PlatformUI.getWorkbench().getDisplay().isDisposed()) {
            return;
        }
        SimanticsConsole console = SimanticsConsole.findConsole();
        if (console != null) {
            ServiceReference ref = this.context.getServiceReference(UnhandledExceptionService.class.getName());
            if (ref != null) {
                UnhandledExceptionService service = (UnhandledExceptionService)this.context.getService(ref);
                service.registerHandler(t -> {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    console.write(sw.toString());
                });
            }
            ConsoleAppender ca = new ConsoleAppender(console);
            Logger logbackLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
            logbackLogger.addAppender((Appender)ca);
            ca.start();
        }
    }
}

