/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.platform.ui.internal;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.simantics.UnhandledExceptionService;
import org.simantics.platform.ui.SimanticsConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator extends AbstractUIPlugin {

    private BundleContext context;

    public Activator() {
    }

    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.context = context;

        if (PlatformUI.isWorkbenchRunning())
            PlatformUI.getWorkbench().getDisplay().asyncExec(this::initConsole);
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        this.context = null;
        super.stop(context);
    }

    private void initConsole() {
        if (PlatformUI.getWorkbench().getDisplay().isDisposed())
             return;

        SimanticsConsole console = SimanticsConsole.findConsole();
        if (console != null) {
            ServiceReference<?> ref = context.getServiceReference(UnhandledExceptionService.class.getName());
            if (ref != null) {
                UnhandledExceptionService service = (UnhandledExceptionService) context.getService(ref);
                service.registerHandler(t -> {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    console.write(sw.toString());
                });
            }
            ConsoleAppender ca = new ConsoleAppender(console);
            ch.qos.logback.classic.Logger logbackLogger =
                    (ch.qos.logback.classic.Logger) LoggerFactory.getLogger(Logger.ROOT_LOGGER_NAME);
            logbackLogger.addAppender(ca);
            ca.start();
        }
    }

}
