/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.structural.rules.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.rules.domain.IDomainAccessor;
import org.simantics.objmap.structural.StructuralResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatedOrderedSetElementsAccessor
implements IDomainAccessor<StructuralResource, Collection<StructuralResource>> {
    static Logger LOGGER = LoggerFactory.getLogger(RelatedOrderedSetElementsAccessor.class);
    boolean deleteExtraObjects;
    boolean useTypeResource;

    public RelatedOrderedSetElementsAccessor(boolean deleteExtraObjects, boolean useTypeResource) {
        this.deleteExtraObjects = deleteExtraObjects;
        this.useTypeResource = useTypeResource;
    }

    @Override
    public Collection<StructuralResource> get(ReadGraph g, StructuralResource element) throws MappingException {
        try {
            LOGGER.trace("        RelatedOrderedSetElementsAccessor.get");
            Resource res = this.getServiceResource(g, element);
            if (res == null) {
                return Collections.emptyList();
            }
            List list = OrderedSetUtils.toList((ReadGraph)g, (Resource)res);
            ArrayList<StructuralResource> result = new ArrayList<StructuralResource>(list.size());
            for (Resource r : list) {
                result.add(new StructuralResource(g, r, element.getContext()));
            }
            return result;
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public boolean set(WriteGraph g, StructuralResource element, Collection<StructuralResource> value) throws MappingException {
        Resource res;
        block4: {
            LOGGER.trace("        RelatedOrderedSetElementsAccessor.set");
            res = this.getServiceResource((ReadGraph)g, element);
            if (res != null) break block4;
            return false;
        }
        try {
            ArrayList<Resource> list = new ArrayList<Resource>(value.size());
            for (StructuralResource r : value) {
                list.add(r.getResource());
            }
            return OrderedSetUtils.set((WriteGraph)g, (Resource)res, list);
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    private Resource getServiceResource(ReadGraph g, StructuralResource element) {
        if (!this.useTypeResource) {
            return element.getResource();
        }
        return element.getTypeResource();
    }
}

