/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.rules.range;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.rules.range.IRangeAccessor;

public class GetSetObjectAccessor<Range, T>
implements IRangeAccessor<Range, T> {
    private Method getter;
    private Method setter;

    public GetSetObjectAccessor(Method getter, Method setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public T get(Range element) throws MappingException {
        try {
            return (T)this.getter.invoke(element, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new MappingException(e);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e);
        }
        catch (InvocationTargetException e) {
            throw new MappingException(e.getCause());
        }
    }

    @Override
    public boolean set(Range element, T value) throws MappingException {
        try {
            this.setter.invoke(element, value);
        }
        catch (IllegalArgumentException e) {
            throw new MappingException(e);
        }
        catch (IllegalAccessException e) {
            throw new MappingException(e);
        }
        catch (InvocationTargetException e) {
            throw new MappingException(e.getCause());
        }
        return true;
    }
}

