/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.impl;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.forward.IForwardMapping;
import org.simantics.objmap.graph.impl.Link;
import org.simantics.objmap.graph.impl.Mapping;

public class RangeUpdateRequest<Domain, Range>
implements Read<Integer>,
SyncListener<Integer> {
    Link<Domain, Range> link;
    IForwardMapping<Domain, Range> map;
    Mapping<Domain, Range> mapping;
    int counter;

    public RangeUpdateRequest(Link<Domain, Range> link, IForwardMapping<Domain, Range> map, Mapping<Domain, Range> mapping) {
        this.link = link;
        this.map = map;
        this.mapping = mapping;
        this.counter = 0;
    }

    public Integer perform(ReadGraph g) throws DatabaseException {
        boolean changed = false;
        if (this.map != null) {
            changed = this.link.type.checkChanges(g, this.map, this.link.domainElement, this.link.rangeElement);
        } else if (this.mapping != null) {
            changed = this.link.type.checkChanges(g, this.mapping, this.link.domainElement, this.link.rangeElement);
        }
        return changed ? this.counter + 1 : this.counter;
    }

    public void exception(ReadGraph graph, Throwable throwable) throws DatabaseException {
        if (throwable instanceof DatabaseException) {
            throw (DatabaseException)throwable;
        }
        throw new MappingException(throwable);
    }

    public void execute(ReadGraph graph, Integer result) throws DatabaseException {
        boolean changed = result != this.counter;
        this.counter = result;
        if (this.map != null) {
            if (changed) {
                this.link.type.updateRange(graph, this.map, this.link.domainElement, this.link.rangeElement);
            }
            this.map = null;
        } else if (this.mapping != null && changed) {
            this.mapping.domainModified(this.link);
            this.mapping = null;
        }
    }

    public boolean isDisposed() {
        return this.mapping == null || this.link.removed || this.mapping.isDisposed();
    }
}

