/*******************************************************************************
 * Copyright (c) 2012, 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.structural.annotations.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.graph.rules.MappedElementsRule;
import org.simantics.objmap.graph.rules.factory.ICollectionRuleFactory;
import org.simantics.objmap.graph.rules.range.CollectionAccessor;
import org.simantics.objmap.structural.StructuralResource;
import org.simantics.objmap.structural.annotations.StructuralRelatedElementsAdd;
import org.simantics.objmap.structural.annotations.StructuralRelatedElementsGet;
import org.simantics.objmap.structural.annotations.StructuralRelatedElementsRem;
import org.simantics.objmap.structural.rules.domain.StructuralRelatedObjectsAccessor;


public class StructuralRelatedElementsRuleFactory2<Range> implements ICollectionRuleFactory<StructuralResource,Range> {
	
	@Override
	public IBidirectionalMappingRule<StructuralResource, Range> create(ReadGraph g, Annotation annotation,
			Method getter, Method adder, Method remover)
			throws DatabaseException {
		StructuralRelatedElementsGet getterAnn = (StructuralRelatedElementsGet)annotation;
		return new MappedElementsRule<StructuralResource,Range>(new StructuralRelatedObjectsAccessor(g.getResource(getterAnn.value()),getterAnn.composition()),
					new CollectionAccessor<Range,Range>(getter, adder, remover));
	}
	
	@Override
	public boolean isAdder(Annotation getterAnnotation, Annotation annotation) {
		StructuralRelatedElementsGet getterAnn = (StructuralRelatedElementsGet)getterAnnotation;
		StructuralRelatedElementsAdd adderAnn = (StructuralRelatedElementsAdd)annotation;
		return getterAnn.value().equals(adderAnn.value());
	}
	
	@Override
	public boolean isRemover(Annotation getterAnnotation, Annotation annotation) {
		StructuralRelatedElementsGet getterAnn = (StructuralRelatedElementsGet)getterAnnotation;
		StructuralRelatedElementsRem adderAnn = (StructuralRelatedElementsRem)annotation;
		return getterAnn.value().equals(adderAnn.value());
	}

}
