/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.structural.annotations.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.graph.annotations.RelatedOrderedSetElements;
import org.simantics.objmap.graph.rules.MappedElementsRule;
import org.simantics.objmap.graph.rules.factory.IFieldRuleFactory;
import org.simantics.objmap.graph.rules.range.FieldAccessor;
import org.simantics.objmap.structural.StructuralResource;
import org.simantics.objmap.structural.rules.domain.RelatedOrderedSetElementsAccessor;


public class RelatedOrderedSetElementsRuleFactory<Range> implements IFieldRuleFactory<StructuralResource, Range> {

    @Override
    public IBidirectionalMappingRule<StructuralResource, Range> create(ReadGraph g, Annotation _annotation, Field field) throws ResourceNotFoundException, ValidationException, ServiceException {
        RelatedOrderedSetElements annotation = (RelatedOrderedSetElements)_annotation;
        return new MappedElementsRule<StructuralResource,Range>(
                new RelatedOrderedSetElementsAccessor(annotation.composition(),false),
                new FieldAccessor<Range,Collection<Range>>(field)
                );
    }

}
