/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.rules.range;

import org.simantics.objmap.exceptions.MappingException;



/**
 * Provides access to some property of range elements.
 * @author Hannu Niemist
 */
public interface IRangeAccessor<Range,T> {
	T get(Range element) throws MappingException;
	boolean set(Range element, T value) throws MappingException;
}
