/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.annotations.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.graph.annotations.OptionalRelatedElements;
import org.simantics.objmap.graph.rules.MappedElementsRule;
import org.simantics.objmap.graph.rules.domain.RelatedObjectsAccessor;
import org.simantics.objmap.graph.rules.factory.IFieldRuleFactory;
import org.simantics.objmap.graph.rules.range.FieldAccessorWithDefault;


public class OptionalRelatedElementsRuleFactory<Range> implements IFieldRuleFactory<Resource, Range> {

    @Override
    public IBidirectionalMappingRule<Resource, Range> create(ReadGraph g, Annotation _annotation, Field field) throws ResourceNotFoundException, ValidationException, ServiceException {
        OptionalRelatedElements annotation = (OptionalRelatedElements)_annotation;
        return new MappedElementsRule<Resource, Range>(
                new RelatedObjectsAccessor(g.getResource(annotation.value()),
                        annotation.composition()),
                new FieldAccessorWithDefault<Range,Collection<Range>>(field, Collections.<Range>emptyList())
                );
    }

}
