/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum oy - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.annotations.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.graph.annotations.LinkedListAdd;
import org.simantics.objmap.graph.annotations.LinkedListGet;
import org.simantics.objmap.graph.annotations.LinkedListRem;
import org.simantics.objmap.graph.rules.MappedElementsRule;
import org.simantics.objmap.graph.rules.domain.LinkedListAccessor;
import org.simantics.objmap.graph.rules.factory.ICollectionRuleFactory;
import org.simantics.objmap.graph.rules.range.CollectionAccessor;

public class LinkedListRuleFactory2<Range> implements ICollectionRuleFactory<Resource,Range> {
	
	@Override
	public IBidirectionalMappingRule<Resource, Range> create(ReadGraph g, Annotation annotation,
			Method getter, Method adder, Method remover)
			throws DatabaseException {
		LinkedListGet getterAnn = (LinkedListGet)annotation;
		return new MappedElementsRule<Resource,Range>(new LinkedListAccessor(g.getResource(getterAnn.value()), g.getResource(getterAnn.type()), getterAnn.composition()),
					new CollectionAccessor<Range,Range>(getter, adder, remover));
	}
	
	@Override
	public boolean isAdder(Annotation getterAnnotation, Annotation annotation) {
		LinkedListGet getterAnn = (LinkedListGet)getterAnnotation;
		LinkedListAdd adderAnn = (LinkedListAdd)annotation;
		return getterAnn.value().equals(adderAnn.value());
	}
	
	@Override
	public boolean isRemover(Annotation getterAnnotation, Annotation annotation) {
		LinkedListGet getterAnn = (LinkedListGet)getterAnnotation;
		LinkedListRem adderAnn = (LinkedListRem)annotation;
		return getterAnn.value().equals(adderAnn.value());
	}

}
