/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.annotations.factories;

import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.error.DatatypeConstructionException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.StringType;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.layer0.Layer0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeUtils {
    
    private static final Logger LOGGER = LoggerFactory.getLogger(DataTypeUtils.class);

    public static Resource dataTypeOfClass(ReadGraph g, Class<?> clazz) {
        Layer0 b = Layer0.getInstance(g);
        if(clazz.equals(Double.class) || clazz.equals(double.class))
            return b.Double;
        else if(clazz.equals(String.class))
            return b.String;
        else if(clazz.equals(Integer.class) || clazz.equals(int.class))
            return b.Integer;
        else if(clazz.equals(Float.class) || clazz.equals(float.class))
            return b.Float;
        else if(clazz.equals(Boolean.class) || clazz.equals(boolean.class))
            return b.Boolean;
        else if(clazz.equals(Long.class) || clazz.equals(long.class))
            return b.Long;
        else if(clazz.equals(Byte.class) || clazz.equals(byte.class))
            return b.Byte;
        
        else if(clazz.equals(double[].class))
            return b.DoubleArray;
        else if(clazz.equals(int[].class))
            return b.IntegerArray;
        else if(clazz.equals(byte[].class))
            return b.ByteArray;
        else if(clazz.equals(float[].class))
            return b.FloatArray;
        else if(clazz.equals(boolean[].class))
            return b.BooleanArray;
        else if(clazz.equals(String[].class))
            return b.StringArray;
        else if(clazz.equals(long[].class))
            return b.LongArray;
        else {
            try {
                Datatype type = Datatypes.getDatatype(clazz);
                final Resource result = dataTypeOfDatatype(g, type);
                if (result != null)
                    return result;
            } catch (DatatypeConstructionException e) {
            }
            
            LOGGER.error("No literal type found for class {}", clazz);
            return null;
        }
    }

    public static Resource dataTypeOfDatatype(ReadGraph g, Datatype type) {
        if (type instanceof OptionalType)
            return dataTypeOfDatatype(g, ((OptionalType) type).getComponentType());
        
        Layer0 b = Layer0.getInstance(g);
        if (type instanceof DoubleType)
            return b.Double;
        else if(type instanceof StringType)
            return b.String;
        else if(type instanceof IntegerType)
            return b.Integer;
        else if(type instanceof FloatType)
            return b.Float;
        else if(type instanceof BooleanType)
            return b.Boolean;
        else if(type instanceof LongType)
            return b.Long;
        else if(type instanceof ByteType)
            return b.Byte;
        
        else if (type instanceof ArrayType) {
            type = ((ArrayType) type).componentType();
            
            if (type instanceof DoubleType)
                return b.DoubleArray;
            else if(type instanceof IntegerType)
                return b.IntegerArray;
            else if(type instanceof ByteType)
                return b.ByteArray;
            else if(type instanceof FloatType)
                return b.FloatArray;
            else if(type instanceof BooleanType)
                return b.BooleanArray;
            else if(type instanceof StringType)
                return b.StringArray;
            else if(type instanceof LongType)
                return b.LongArray;
        }
        
        LOGGER.error("No literal type found for data type {}", type);
        return null;
    }
}
