/*******************************************************************************
 * Copyright (c) 2012, 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.simantics.objmap.graph.annotations.meta.IsGetSetRule;
import org.simantics.objmap.graph.rules.adapters.IdentityAdapter;
import org.simantics.objmap.graph.rules.adapters.ValueAdapter;



@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
//@HasGetSetRuleFactory(RelatedGetSetValueRuleFactory.class)
@IsGetSetRule
@HasSetter(RelatedSetValue.class)
public @interface RelatedGetValue {
	String value();
	 Class<? extends ValueAdapter> adapter() default IdentityAdapter.class;
}
