/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.backward;

import org.simantics.db.WriteGraph;
import org.simantics.objmap.exceptions.MappingException;

public interface IBackwardMappingRule<Domain, Range> {
    /**
     * Modifies the domain element so that it corresponds to the range element.
     * @param g write transaction
     * @param map unidirectional view of the current mapping
     * @param domainElement the domain element that is updated
     * @param rangeElement the range element that corresponds to the domain element
     * @return true if the rule made some modifications
     * @throws MappingException 
     */    
	boolean updateDomain(WriteGraph graph, IBackwardMapping<Domain, Range> mapping, Domain domainElement, Range rangeElement) throws MappingException;
	void createDomain(WriteGraph graph, IBackwardMapping<Domain, Range> mapping, Domain domainElement, Range rangeElement) throws MappingException;
}
