/*******************************************************************************
 * Copyright (c) 2012, 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.backward;

import java.util.Set;

import org.simantics.db.WriteGraph;
import org.simantics.objmap.exceptions.MappingException;

/**
 * A backward mapping is a one-to-one correspondence between domain and range
 * elements. It supports adding new range elements and creating corresponding
 * domain elements.
 * 
 * @author Hannu Niemist&ouml;
 */
public interface IBackwardMapping<Domain, Range> {
    Set<Range> getRange();
    Domain inverseGet(Range rangeElement);
    Domain inverseMap(WriteGraph graph, Range rangeElement) throws MappingException;
}
