/*******************************************************************************
 * Copyright (c) 2016, 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.nativemem.internal.win;

import org.simantics.nativemem.ProcessMemoryInfo;
import org.simantics.nativemem.internal.Util;

/**
 * Architecture-independent version of the Windows PsApi PROCESS_MEMORY_COUNTERS
 * structure.
 * 
 * @author Tuukka Lehtonen
 */
public class ProcessMemoryCounters implements ProcessMemoryInfo {
    public int PageFaultCount;
    public long PeakWorkingSetSize;
    public long WorkingSetSize;
    public long QuotaPeakPagedPoolUsage;
    public long QuotaPagedPoolUsage;
    public long QuotaPeakNonPagedPoolUsage;
    public long QuotaNonPagedPoolUsage;
    public long PagefileUsage;
    public long PeakPagefileUsage;
    public long PrivateUsage;

    @Override
    public String toString() {
        return "ProcessMemoryCounters [PageFaultCount="
                + PageFaultCount + ", PeakWorkingSetSize=" + PeakWorkingSetSize
                + ", WorkingSetSize=" + WorkingSetSize
                + ", QuotaPeakPagedPoolUsage=" + QuotaPeakPagedPoolUsage
                + ", QuotaPagedPoolUsage=" + QuotaPagedPoolUsage
                + ", QuotaPeakNonPagedPoolUsage=" + QuotaPeakNonPagedPoolUsage
                + ", QuotaNonPagedPoolUsage=" + QuotaNonPagedPoolUsage
                + ", PagefileUsage=" + PagefileUsage + ", PeakPagefileUsage="
                + PeakPagefileUsage + ", PrivateUsage=" + PrivateUsage + "]";
    }

    @Override
    public String toHumanReadableString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RSS                 ").append(Util.toMb(WorkingSetSize))
        .append("M / ").append(Util.toMb(PeakWorkingSetSize))
        .append("M").append(Util.NL)
        .append("Paged/Nonpaged Pool ").append(Util.toKb(QuotaPagedPoolUsage)).append("K / ")
        .append(Util.toKb(QuotaPeakPagedPoolUsage)).append("K  /  ")
        .append(Util.toKb(QuotaNonPagedPoolUsage)).append("K / ")
        .append(Util.toKb(QuotaPeakNonPagedPoolUsage)).append("K").append(Util.NL)
        .append("Page File           ").append(Util.toMb(PagefileUsage))
        .append("M / ").append(Util.toMb(PeakPagefileUsage))
        .append("M (").append(PageFaultCount).append(" faults)");
        return sb.toString();
    }

    @Override
    public String headerRow() {
        return "RSS [MB]\tPeak RSS [MB]\tPaged Pool Usage [kB]\tPeak Paged Pool Usage [kB]\tNonpaged Pool Usage [kB]\tPeak Nonpaged Pool Usage [kB]\tPage File Usage [MB]\tPeak Page File Usage [MB]\tPage Faults";
    }

    @Override
    public String dataRow() {
        return Util.toMb(WorkingSetSize) + "\t" + Util.toMb(PeakWorkingSetSize)
        + "\t" + Util.toKb(QuotaPagedPoolUsage) + "\t" + Util.toKb(QuotaPeakPagedPoolUsage)
        + "\t" + Util.toKb(QuotaNonPagedPoolUsage) + "\t" + Util.toKb(QuotaPeakNonPagedPoolUsage)
        + "\t" + Util.toMb(PagefileUsage) + "\t" + Util.toMb(PeakPagefileUsage)
        + "\t" + PageFaultCount;
    }

    public static void main(String[] args) {
        System.out.println(new ProcessMemoryCounters().toHumanReadableString());
        System.out.println(new ProcessMemoryCounters().headerRow());
        System.out.println(new ProcessMemoryCounters().dataRow());
    }

}