package org.simantics.msvc.runtime;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;

import org.eclipse.core.runtime.Path;

/**
 * @author Tuukka Lehtonen
 */
public final class Runtimes {

    public static final String VC_2010 = "vc2010";

    static boolean vc100Initialized = false;

    public static void initialize(String vc) {
        OSType os = OSType.calculate();
        if (os == OSType.WINDOWS) {
            if (VC_2010.equals(vc) && !vc100Initialized) {
                initializeVC100();
            }
        }
    }

    static synchronized void initializeVC100() {
        try {
            // Works in OSGi environment.
            System.loadLibrary("msvcr100");
            System.loadLibrary("msvcp100");
            vc100Initialized = true;
        } catch (UnsatisfiedLinkError e) {
            // Try to load from a workspace in POJO environment.
            try {
                String archStr = ARCHType.calculate().toString().toLowerCase();
                URL url = Runtimes.class.getResource(".");
                File dir = new File(URLDecoder.decode(url.getPath(), "UTF-8") + "../../../../../../org.simantics.msvc.runtime." + archStr);
                dir = new Path(dir.getAbsolutePath()).toFile();
                String vcr = new File(dir, "msvcr100.dll").getAbsolutePath();
                String vcp = new File(dir, "msvcp100.dll").getAbsolutePath();
                System.load(vcr);
                System.load(vcp);
                vc100Initialized = true;
            } catch (UnsupportedEncodingException e1) {
                throw new Error("UTF-8 not supported, impossible");
            }
        }
    }

    public enum ARCHType {
        PPC, PPC_64, SPARC, X86, X86_64, UNKNOWN;

        public static ARCHType calculate() {
            String osArch = System.getProperty("os.arch");
            assert osArch != null;
            osArch = osArch.toLowerCase();
            if (osArch.equals("i386") || osArch.equals("i586") || osArch.equals("i686") || osArch.equals("x86"))
                return X86;
            if (osArch.startsWith("amd64") || osArch.startsWith("x86_64"))
                return X86_64;
            if (osArch.equals("ppc"))
                return PPC;
            if (osArch.startsWith("ppc"))
                return PPC_64;
            if (osArch.startsWith("sparc"))
                return SPARC;
            return UNKNOWN;
        }
    }

    public enum OSType {
        APPLE, LINUX, SUN, WINDOWS, UNKNOWN;

        public static OSType calculate() {
            String osName = System.getProperty("os.name");
            assert osName != null;
            osName = osName.toLowerCase();
            if (osName.startsWith("mac os x"))
                return APPLE;
            if (osName.startsWith("windows"))
                return WINDOWS;
            if (osName.startsWith("linux"))
                return LINUX;
            if (osName.startsWith("sun"))
                return SUN;
            return UNKNOWN;
        }
    }

}
