# Simantics/SCL

This module contains functions closely related to SCL and storing
SCL related constructs in the Simantics database.

## SCL Command Session

::data[CommandResponse]
::value[createTextAndErrors]
::value[execute]
::value[isSuccessful]

### SCL Realm

::value[getOrCreateSCLRealm]
::value[readSCLRealm]
::value[refreshVariables]
::value[sclRealmById]
::value[syncExec]

### Command Session Variable Access

::value[setVariable]
::value[variableValue]

## SCL Values

::value[createSCLValue]
::value[createSCLValueIndependent]
::value[setExpression]

## SCL Modules

::value[createSCLModuleAction]
::value[createSCLModuleDefault]
::value[createSCLModule]
::value[createSCLModuleR]
::value[createSCLModuleWithDefinition]
::value[setSCLModuleDefinition]

## SCL Scripts

::value[createSCLScriptAction]
::value[createSCLScriptDefault]
::value[createSCLScript]
::value[createSCLScriptR]
::value[createSCLScriptWithDefinition]
::value[executeSCLScript]
::value[setSCLScriptDefinition]

## Ontology definitions (PGraphs)

PGraph (partial graph) is a textual format for specifying ontologies for Simantics.
For more information on the format, see [this documentation](http://dev.simantics.org/index.php/Graph_File_Format).

::value[createPGraphAction]
::value[createPGraphDefault]
::value[createPGraph]
::value[createPGraphR]
::value[setPGraphDefinition]
