/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.utils;

import gnu.trove.list.array.TByteArrayList;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpOntologyStructure {
    private static final Logger LOGGER = LoggerFactory.getLogger(DumpOntologyStructure.class);
    private Resource ontology;
    private Map<Resource, String> names = new HashMap<Resource, String>();
    private Map<Resource, Resource> parents = new TreeMap<Resource, Resource>();
    private Map<Resource, File> libraryFolders = new HashMap<Resource, File>();
    private Map<Resource, byte[]> contentDumps = new HashMap<Resource, byte[]>();

    private void readNameAndParent(ReadGraph graph, Resource container, Resource r) throws DatabaseException {
        String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
        this.parents.put(r, container);
        this.names.put(r, FileUtils.escapeFileName((String)name));
    }

    private Collection<Resource> sortedContainers(File rootFolder) {
        HashSet<Resource> parentSet = new HashSet<Resource>(this.parents.values());
        TreeMap<String, Resource> result = new TreeMap<String, Resource>();
        for (Resource r : parentSet) {
            File f = this.getFolder(rootFolder, r);
            result.put(f.getAbsolutePath(), r);
        }
        return result.values();
    }

    private Collection<Resource> sortedResources(File rootFolder) {
        TreeMap<String, Resource> result = new TreeMap<String, Resource>();
        for (Resource r : this.parents.keySet()) {
            File f;
            byte[] dump = this.contentDumps.get(r);
            if (dump == null) {
                dump = "".getBytes(StandardCharsets.UTF_8);
            }
            if (this.isParent(r)) {
                if (dump.length <= 0) continue;
                f = new File(this.getFolder(rootFolder, r), "__contents__");
                result.put(f.getAbsolutePath(), r);
                continue;
            }
            f = this.getFile(rootFolder, r);
            result.put(f.getAbsolutePath(), r);
        }
        return result.values();
    }

    private void readHierarchy(ReadGraph graph, Resource container) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource r : CommonDBUtils.objectsWithType((ReadGraph)graph, (Resource)container, (Resource)L0.ConsistsOf, (Resource)L0.Entity)) {
            try {
                this.readNameAndParent(graph, container, r);
                this.readHierarchy(graph, r);
            }
            catch (DatabaseException e) {
                LOGGER.error("Error while reading content dump hierarchy for " + r, (Throwable)e);
            }
        }
    }

    private void readGeneric(ReadGraph graph) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        for (Resource r : this.parents.keySet()) {
            if (this.contentDumps.containsKey(r)) continue;
            TByteArrayList result = new TByteArrayList();
            try {
                TreeMap<String, Resource> sortedTypes = new TreeMap<String, Resource>();
                for (Resource type : graph.getTypes(r)) {
                    String uri = graph.getPossibleURI(type);
                    if (uri == null) continue;
                    sortedTypes.put(uri, type);
                }
                for (Resource type : sortedTypes.values()) {
                    try {
                        byte[] dump;
                        Variable typeVariable = Variables.getVariable((ReadGraph)graph, (Resource)type);
                        Function f = (Function)typeVariable.getPossiblePropertyValue(graph, MOD.contentDumpFunction);
                        if (f == null || (dump = (byte[])Simantics.applySCLRead((ReadGraph)graph, (Function1)f, (Object)r)) == null) continue;
                        result.add(dump);
                    }
                    catch (DatabaseException e) {
                        LOGGER.error("Error while computing content dump for " + r, (Throwable)e);
                    }
                }
                if (result.size() <= 0) continue;
                this.contentDumps.put(r, result.toArray());
            }
            catch (DatabaseException e) {
                LOGGER.error("Error while computing content dump for " + r, (Throwable)e);
            }
        }
    }

    public DumpOntologyStructure read(ReadGraph graph, Resource ontology) throws DatabaseException {
        this.ontology = ontology;
        this.readHierarchy(graph, ontology);
        this.readGeneric(graph);
        return this;
    }

    private File escapeFile(File file) {
        if (file.exists()) {
            return file;
        }
        return new File(this.escapeFile(file.getParentFile()), FileUtils.escapeFileName((String)file.getName()));
    }

    public void write(File unsafeFolder) throws IOException {
        File folder = this.escapeFile(unsafeFolder);
        FileUtils.delete((Path)folder.toPath());
        folder.getParentFile().mkdirs();
        this.writeDirectories(folder);
        this.writeResources(folder);
    }

    Resource getParent(Resource r) {
        return this.parents.get(r);
    }

    private File getFolder(File root, Resource library) {
        if (this.ontology.equals(library)) {
            return root;
        }
        Resource parent = this.getParent(library);
        if (parent == null) {
            throw new IllegalStateException("null parent for " + library);
        }
        File parentFolder = this.getFolder(root, parent);
        return new File(parentFolder, this.names.get(library));
    }

    private File getFile(File rootFolder, Resource r) {
        Resource parent = this.getParent(r);
        File folder = this.getFolder(rootFolder, parent);
        return new File(folder, this.names.get(r));
    }

    private File makeUnique(File original, Resource r) {
        File file;
        int counter = 2;
        File test = file = new File(original.getParent(), original.getName());
        while (test.exists()) {
            test = new File(file.getParent(), String.valueOf(file.getName()) + "____" + counter++);
        }
        this.names.put(r, test.getName());
        return test;
    }

    private void writeDirectories(File rootFolder) {
        for (Resource library : this.sortedContainers(rootFolder)) {
            File folder = this.makeUnique(this.getFolder(rootFolder, library), library);
            folder.mkdirs();
            this.libraryFolders.put(library, folder);
        }
    }

    private void writeResources(File rootFolder) throws IOException {
        for (Resource r : this.sortedResources(rootFolder)) {
            this.writeResource(rootFolder, r);
        }
    }

    private boolean isParent(Resource r) {
        return this.parents.values().contains(r);
    }

    private void writeResource(File rootFolder, Resource resource) throws IOException {
        byte[] dump = this.contentDumps.get(resource);
        if (dump == null) {
            dump = "".getBytes(StandardCharsets.UTF_8);
        }
        if (this.isParent(resource)) {
            if (dump.length > 0) {
                FileUtils.writeFile((File)new File(this.getFolder(rootFolder, resource), "__contents__"), (byte[])dump);
            }
        } else {
            this.write(rootFolder, resource, dump);
        }
    }

    private void write(File rootFolder, Resource resource, byte[] bytes) throws IOException {
        FileUtils.writeFile((File)this.makeUnique(this.getFile(rootFolder, resource), resource), (byte[])bytes);
    }
}

