/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl;

import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadExt;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingUtils;
import org.simantics.modeling.internal.Activator;
import org.simantics.modeling.scl.ontologymodule.OntologyModuleSourceRepository;
import org.simantics.scl.compiler.internal.codegen.types.JavaReferenceValidatorFactory;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.StringModuleSource;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;
import org.simantics.scl.osgi.internal.OsgiJavaReferenceValidatorFactory;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.structural2.utils.StructuralUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum GraphModuleSourceRepository implements ModuleSourceRepository
{
    INSTANCE;

    private static final Logger LOGGER;
    private static final OsgiJavaReferenceValidatorFactory REFERENCE_VALIDATOR_FACTORY;

    static {
        LOGGER = LoggerFactory.getLogger(OntologyModuleSourceRepository.class);
        REFERENCE_VALIDATOR_FACTORY = new OsgiJavaReferenceValidatorFactory(Activator.getContext().getBundle());
    }

    public ModuleSource getModuleSource(String moduleName, UpdateListener listener) {
        if (!moduleName.startsWith("http://")) {
            return null;
        }
        ReadModuleSource request = new ReadModuleSource(moduleName);
        try {
            if (listener != null) {
                return (ModuleSource)Simantics.getAvailableRequestProcessor().syncRequest((Read)request, (SyncListener)new ModuleListener(listener, moduleName));
            }
            return (ModuleSource)Simantics.getAvailableRequestProcessor().syncRequest((Read)request);
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to read graph module {}.", (Object)moduleName, (Object)e);
            return null;
        }
    }

    private THashSet<String> getAllModules(ReadGraph graph) throws DatabaseException {
        THashSet result = new THashSet();
        Resource projectResource = Simantics.getProjectResource();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource model : graph.getObjects(projectResource, L0.ConsistsOf)) {
            if (!graph.isInstanceOf(model, L0.IndexRoot)) continue;
            for (Resource module : ModelingUtils.searchByType(graph, model, L0.SCLModule)) {
                result.add((Object)graph.getURI(module));
            }
        }
        Collection ontologies = (Collection)Simantics.applySCL((String)"Simantics/SharedOntologies", (String)"getSharedOntologies", (ReadGraph)graph, (Object[])new Object[]{Tuple0.INSTANCE});
        for (Resource ontology : ontologies) {
            for (Resource module : ModelingUtils.searchByType(graph, ontology, L0.SCLModule)) {
                try {
                    result.add((Object)graph.getURI(module));
                }
                catch (DatabaseException databaseException) {
                    LOGGER.error("Failed to find uri for " + module + ".");
                }
            }
        }
        return result;
    }

    public void forAllModules(TObjectProcedure<String> procedure) {
        THashSet moduleURIs = null;
        try {
            moduleURIs = (THashSet)Simantics.getAvailableRequestProcessor().syncRequest((Read)new Read<THashSet<String>>(){

                public THashSet<String> perform(ReadGraph graph) throws DatabaseException {
                    return GraphModuleSourceRepository.this.getAllModules(graph);
                }
            });
            moduleURIs.forEach(procedure);
        }
        catch (DatabaseException e) {
            LOGGER.error("Could not execute procedure {} for all modules {}", new Object[]{procedure, String.valueOf(moduleURIs), e});
        }
    }

    public Collection<String> getModuleNames() {
        ArrayList<String> result = new ArrayList<String>();
        this.forAllModules((TObjectProcedure<String>)((TObjectProcedure)name -> {
            result.add((String)name);
            return true;
        }));
        return result;
    }

    public static class GraphModuleSource
    extends StringModuleSource {
        private final boolean immutable;

        public GraphModuleSource(String moduleName, ClassLoader classLoader, String moduleText, boolean immutable) {
            super(moduleName, classLoader, moduleText);
            this.immutable = immutable;
        }

        public boolean isUpdateable() {
            return !this.immutable;
        }

        public void update(String newSourceText) {
            try {
                Simantics.getSession().syncRequest((Write)new WriteModuleSource(this.getModuleName(), newSourceText));
            }
            catch (DatabaseException databaseException) {
                LOGGER.error("Could not update {} with newSourceText {}", (Object)this, (Object)newSourceText);
            }
        }

        public JavaReferenceValidatorFactory getJavaReferenceValidatorFactory() {
            return REFERENCE_VALIDATOR_FACTORY;
        }
    }

    static class ModuleListener
    implements SyncListener<ModuleSource>,
    UpdateListener.Observable {
        UpdateListener listener;
        boolean alreadyExecutedOnce;
        final String moduleName;

        public ModuleListener(UpdateListener listener, String moduleName) {
            this.listener = listener;
            this.listener.addObservable((UpdateListener.Observable)this);
            this.moduleName = moduleName;
        }

        public void removeListener(UpdateListener listener) {
            this.listener = null;
        }

        public boolean isDisposed() {
            return this.listener == null;
        }

        private void fireUpdate(ReadGraph graph) {
            if (this.listener != null) {
                SCLContext context = SCLContext.getCurrent();
                Object oldGraph = context.put((Object)"graph", (Object)graph);
                try {
                    this.listener.notifyAboutUpdate();
                }
                finally {
                    this.listener = null;
                    context.put((Object)"graph", oldGraph);
                }
            }
        }

        public void execute(ReadGraph graph, ModuleSource result) throws DatabaseException {
            if (this.alreadyExecutedOnce) {
                this.fireUpdate(graph);
            } else {
                this.alreadyExecutedOnce = true;
            }
        }

        public void exception(ReadGraph graph, Throwable t) throws DatabaseException {
            LOGGER.error("Could not listen {}", (Object)this, (Object)t);
            if (this.alreadyExecutedOnce && this.listener != null) {
                this.fireUpdate(graph);
            }
        }

        public String toString() {
            return String.valueOf(this.moduleName) + " " + this.listener + " (" + this.alreadyExecutedOnce + ") [" + this.getClass().toString() + "]";
        }
    }

    static class PossibleResourceIU
    extends UnaryRead<String, Resource>
    implements ReadExt {
        public PossibleResourceIU(String parameter) {
            super((Object)parameter);
        }

        public Resource perform(ReadGraph graph) throws DatabaseException {
            return graph.getPossibleResource((String)this.parameter);
        }

        public boolean isImmutable(ReadGraph graph) throws DatabaseException {
            return false;
        }

        public int getType() {
            return 1;
        }
    }

    static class ReadModuleSource
    extends UnaryRead<String, ModuleSource> {
        public ReadModuleSource(String moduleName) {
            super((Object)moduleName);
        }

        public ModuleSource perform(ReadGraph graph) throws DatabaseException {
            Resource moduleResource = (Resource)graph.syncRequest((Read)new PossibleResourceIU((String)this.parameter));
            if (moduleResource == null) {
                return null;
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            if (!graph.isInstanceOf(moduleResource, L0.SCLModule)) {
                return null;
            }
            String text = (String)graph.getRelatedValue(moduleResource, L0.SCLModule_definition);
            boolean immutable = StructuralUtils.isImmutable((ReadGraph)graph, (Resource)moduleResource);
            return new GraphModuleSource((String)this.parameter, ((Object)((Object)this)).getClass().getClassLoader(), text, immutable);
        }
    }

    static class WriteModuleSource
    extends WriteRequest {
        private final String moduleURI;
        private final String sourceText;

        public WriteModuleSource(String moduleURI, String sourceText) {
            this.moduleURI = moduleURI;
            this.sourceText = sourceText;
        }

        public void perform(WriteGraph graph) throws DatabaseException {
            Resource moduleResource = graph.getPossibleResource(this.moduleURI);
            if (moduleResource == null) {
                return;
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            if (!graph.isInstanceOf(moduleResource, L0.SCLModule)) {
                return;
            }
            graph.claimLiteral(moduleResource, L0.SCLModule_definition, (Object)this.sourceText);
        }
    }
}

