/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.DefaultPasteHandler;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.PasteEventHandler;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.modeling.mapping.ComponentAndElementPasteImportAdvisor;
import org.simantics.utils.datastructures.hints.IHintContext;

public abstract class ComponentAndElementPasteHandler
extends DefaultPasteHandler {
    protected boolean includeComponent = true;
    protected boolean includeElement = true;

    public ComponentAndElementPasteHandler(Resource composite) {
        super(composite);
    }

    public ComponentAndElementPasteHandler(Resource composite, boolean includeComponent, boolean includeElement) {
        super(composite);
        if (!includeComponent && !includeElement) {
            throw new IllegalArgumentException();
        }
        this.includeElement = includeElement;
        this.includeComponent = includeComponent;
    }

    protected abstract Resource getConfiguration(ReadGraph var1) throws DatabaseException;

    public void onPaste(WriteGraph graph, ComponentAndElementPasteImportAdvisor advisor, Set<SimanticsClipboard.Representation> representations) throws DatabaseException {
    }

    protected void createdElementInAdvisor(WriteGraph graph, Resource element) throws DatabaseException {
    }

    public Collection<Resource> pasteObject(WriteGraph graph, Set<SimanticsClipboard.Representation> object, PasteEventHandler handler) throws DatabaseException {
        ArrayList<Resource> result = new ArrayList<Resource>();
        TransferableGraph1 tg = (TransferableGraph1)ClipboardUtils.accept((ReadGraph)graph, object, (IHintContext.Key)SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
        if (tg != null) {
            this.doPaste(graph, object, tg, result);
        }
        return result;
    }

    public void doPaste(WriteGraph graph, Set<SimanticsClipboard.Representation> object, TransferableGraph1 tg, Collection<Resource> result) throws DatabaseException {
        Resource resource = (Resource)this.getAdapter(Resource.class);
        Resource configuration = this.getConfiguration((ReadGraph)graph);
        ComponentAndElementPasteImportAdvisor advisor = new ComponentAndElementPasteImportAdvisor((ReadGraph)graph, configuration, this.includeComponent, this.includeElement){

            @Override
            public void createElement(WriteGraph graph, Resource element) throws DatabaseException {
                ComponentAndElementPasteHandler.this.createdElementInAdvisor(graph, element);
            }
        };
        this.execute(graph, tg, resource, advisor);
        advisor.attach(graph);
        this.onPaste(graph, advisor, object);
        if (advisor.getComponent() != null) {
            result.add(advisor.getComponent());
        } else if (advisor.getElement() != null) {
            result.add(advisor.getElement());
        }
    }
}

