/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.adapters;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.simantics.utils.strings.EString;

public class RemoveInstancesDialog
extends MessageDialog {
    protected String message;
    protected boolean hasDetails;
    protected Content[] content;
    protected LocalResourceManager resourceManager;
    protected Composite tableAndButtons;
    protected Text messageText;
    protected Text detailsText;
    private GridData detailsGridData;

    public RemoveInstancesDialog(Shell parentShell, String dialogTitle, String dialogMessage, Content[] content) {
        this(parentShell, dialogTitle, dialogMessage, 3, new String[]{IDialogConstants.PROCEED_LABEL, IDialogConstants.CANCEL_LABEL}, 1, content);
    }

    public RemoveInstancesDialog(Shell parentShell, String dialogTitle, String dialogMessage, int dialogType, String[] buttons, int defaultIndex, Content[] content) {
        super(parentShell, dialogTitle, null, null, dialogType, buttons, defaultIndex);
        this.message = dialogMessage;
        this.content = content;
        this.hasDetails = this.contentHasDetails(content);
    }

    private boolean contentHasDetails(Content[] content) {
        Content[] contentArray = content;
        int n = content.length;
        int n2 = 0;
        while (n2 < n) {
            Content c = contentArray[n2];
            if (c.details != null && !c.details.trim().isEmpty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Control createDialogArea(Composite parent) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        return composite;
    }

    protected Control createMessageArea(Composite composite) {
        super.createMessageArea(composite);
        if (this.message != null) {
            this.messageText = new Text(composite, this.getMessageLabelStyle());
            this.messageText.setText(this.message);
            this.messageText.setEditable(false);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.messageText);
        }
        return composite;
    }

    protected Control createCustomArea(Composite parent) {
        this.tableAndButtons = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tableAndButtons);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.tableAndButtons);
        Label uses = new Label(this.tableAndButtons, 0);
        uses.setText("Instances:");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)uses);
        TableColumnLayout ad = new TableColumnLayout();
        Composite tableComposite = new Composite(this.tableAndButtons, 0);
        GridDataFactory.fillDefaults().grab(true, true).minSize(300, 300).applyTo((Control)tableComposite);
        tableComposite.setLayout((Layout)ad);
        TableViewer viewer = new TableViewer(tableComposite, 68352);
        viewer.setContentProvider((IContentProvider)new CP());
        TableViewerColumn c1 = new TableViewerColumn(viewer, 16384);
        c1.setLabelProvider((CellLabelProvider)new LP());
        ad.setColumnData((Widget)c1.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, 100, true));
        Composite buttons = new Composite(this.tableAndButtons, 0);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)buttons);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(buttons);
        Button copyButton = new Button(buttons, 8);
        copyButton.setText("&Copy to Clipboard");
        copyButton.setToolTipText("Copy List Contents to Clipboard");
        copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = EString.implode((Object[])RemoveInstancesDialog.this.content, (String)String.format("%n", new Object[0]));
                Clipboard cp = new Clipboard(e.display);
                cp.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
                cp.dispose();
            }
        });
        this.detailsText = new Text(this.tableAndButtons, 2626);
        Color bg = this.detailsText.getBackground();
        this.detailsText.setEditable(false);
        this.detailsText.setBackground(bg);
        this.detailsGridData = GridDataFactory.fillDefaults().grab(true, false).hint(-1, 100).span(2, 1).create();
        this.detailsText.setLayoutData((Object)this.detailsGridData);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Content content = (Content)sel.getFirstElement();
                RemoveInstancesDialog.this.showDetails(content);
            }
        });
        viewer.setInput((Object)this.content);
        this.detailsText.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                RemoveInstancesDialog.this.showDetails(null);
            }
        });
        return this.tableAndButtons;
    }

    protected void showDetails(Content content) {
        if (this.detailsText == null || this.detailsText.isDisposed()) {
            return;
        }
        if (content != null && content.details != null) {
            this.detailsText.setText(content.details);
            if (this.detailsGridData.exclude) {
                this.detailsGridData.exclude = false;
                this.detailsGridData.heightHint = 100;
                this.tableAndButtons.layout(true, true);
            }
        } else {
            this.detailsText.setText("");
            if (!this.detailsGridData.exclude) {
                this.detailsGridData.exclude = true;
                this.detailsGridData.heightHint = 0;
                this.detailsText.setSize(0, 0);
                this.tableAndButtons.layout(true, true);
            }
        }
    }

    protected class CP
    implements IStructuredContentProvider {
        protected CP() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return RemoveInstancesDialog.this.content;
        }
    }

    public static class Content {
        public String label;
        public ImageDescriptor image;
        public String details;

        public Content(String label) {
            assert (label != null);
            this.label = label;
        }

        public String toString() {
            if (this.details == null) {
                return this.label;
            }
            return String.valueOf(this.label) + "\nDetails: " + this.details;
        }
    }

    protected class LP
    extends ColumnLabelProvider {
        protected LP() {
        }

        public Image getImage(Object element) {
            Content content = (Content)element;
            return content.image != null ? (Image)RemoveInstancesDialog.this.resourceManager.get((DeviceResourceDescriptor)content.image) : null;
        }

        public String getText(Object element) {
            Content content = (Content)element;
            return content.label;
        }
    }
}

