/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import gnu.trove.map.hash.THashMap;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.StringType;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLTypeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLTypeUtils.class);
    private static final THashMap<String, Type> TYPE_MAP = new THashMap();
    private static final TVar STAR = Types.var((Kind)Kinds.STAR);

    static {
        SCLTypeUtils.add(Types.BOOLEAN);
        SCLTypeUtils.add(Types.BYTE);
        SCLTypeUtils.add(Types.CHARACTER);
        SCLTypeUtils.add(Types.SHORT);
        SCLTypeUtils.add(Types.INTEGER);
        SCLTypeUtils.add(Types.LONG);
        SCLTypeUtils.add(Types.FLOAT);
        SCLTypeUtils.add(Types.DOUBLE);
        SCLTypeUtils.add(Types.STRING);
        TYPE_MAP.put((Object)"[Boolean]", (Object)Types.list((Type)Types.BOOLEAN));
        TYPE_MAP.put((Object)"[Byte]", (Object)Types.list((Type)Types.BYTE));
        TYPE_MAP.put((Object)"[Character]", (Object)Types.list((Type)Types.CHARACTER));
        TYPE_MAP.put((Object)"[Short]", (Object)Types.list((Type)Types.SHORT));
        TYPE_MAP.put((Object)"[Integer]", (Object)Types.list((Type)Types.INTEGER));
        TYPE_MAP.put((Object)"[Long]", (Object)Types.list((Type)Types.LONG));
        TYPE_MAP.put((Object)"[Float]", (Object)Types.list((Type)Types.FLOAT));
        TYPE_MAP.put((Object)"[Double]", (Object)Types.list((Type)Types.DOUBLE));
        TYPE_MAP.put((Object)"[String]", (Object)Types.list((Type)Types.STRING));
        TYPE_MAP.put((Object)"Vector Boolean", (Object)Types.vector((Type)Types.BOOLEAN));
        TYPE_MAP.put((Object)"Vector Byte", (Object)Types.vector((Type)Types.BYTE));
        TYPE_MAP.put((Object)"Vector Character", (Object)Types.vector((Type)Types.CHARACTER));
        TYPE_MAP.put((Object)"Vector Short", (Object)Types.vector((Type)Types.SHORT));
        TYPE_MAP.put((Object)"Vector Integer", (Object)Types.vector((Type)Types.INTEGER));
        TYPE_MAP.put((Object)"Vector Long", (Object)Types.vector((Type)Types.LONG));
        TYPE_MAP.put((Object)"Vector Float", (Object)Types.vector((Type)Types.FLOAT));
        TYPE_MAP.put((Object)"Vector Double", (Object)Types.vector((Type)Types.DOUBLE));
        TYPE_MAP.put((Object)"Vector String", (Object)Types.vector((Type)Types.STRING));
        TYPE_MAP.put((Object)"ByteArray", (Object)Types.BYTE_ARRAY);
        TCon variable = Types.con((String)"Simantics/Variables", (String)"Variable");
        SCLTypeUtils.add(variable);
        TYPE_MAP.put((Object)"Variable -> Resource -> <ReadGraph> Resource", (Object)Types.functionE((Type[])new Type[]{variable, Types.RESOURCE}, (Type)Types.READ_GRAPH, (Type)Types.RESOURCE));
        SCLTypeUtils.add((TCon)Types.RESOURCE);
        SCLTypeUtils.add(Types.con((String)"Simantics/ChangeInformation", (String)"ChangeInformation"));
        SCLTypeUtils.add(Types.con((String)"Simantics/GUID", (String)"GUID"));
        SCLTypeUtils.add(Types.con((String)"Simantics/Variables", (String)"StructuredProperty"));
        SCLTypeUtils.add(Types.con((String)"Simantics/Variables", (String)"ValueAccessor"));
        SCLTypeUtils.add(Types.con((String)"Simantics/Variables", (String)"VariableMap"));
    }

    private static void add(TCon type) {
        TYPE_MAP.put((Object)type.name, (Object)type);
    }

    public static Type getType(String typeText) {
        Type type = (Type)TYPE_MAP.get((Object)typeText);
        if (type == null) {
            LOGGER.warn("SCLTypeUtils.getType cannot transform '" + typeText + "' to type. Returns a as default.");
            return STAR;
        }
        return type;
    }

    public static Type getType(Datatype dataType) {
        if (dataType instanceof DoubleType) {
            return Types.DOUBLE;
        }
        if (dataType instanceof IntegerType) {
            return Types.INTEGER;
        }
        if (dataType instanceof StringType) {
            return Types.STRING;
        }
        if (dataType instanceof BooleanType) {
            return Types.BOOLEAN;
        }
        if (dataType instanceof FloatType) {
            return Types.FLOAT;
        }
        if (dataType instanceof LongType) {
            return Types.LONG;
        }
        if (dataType instanceof ByteType) {
            return Types.BYTE;
        }
        if (dataType instanceof ArrayType) {
            return Types.list((Type)SCLTypeUtils.getType(((ArrayType)dataType).componentType));
        }
        LOGGER.warn("SCLTypeUtils.getType cannot transform data type '" + dataType + "' to type. Returns a as default.");
        return STAR;
    }

    public static Type getType(PropertyInfo propertyInfo, boolean warnOfNoTypeInformation) {
        if (propertyInfo.requiredValueType != null) {
            return SCLTypeUtils.getType(propertyInfo.requiredValueType);
        }
        if (propertyInfo.requiredDatatype != null) {
            return SCLTypeUtils.getType(propertyInfo.requiredDatatype);
        }
        if (warnOfNoTypeInformation) {
            LOGGER.warn(String.valueOf(propertyInfo.name) + " doesn't have type information. Returns a as default.");
        }
        return STAR;
    }

    public static Type getType(PropertyInfo propertyInfo) {
        return SCLTypeUtils.getType(propertyInfo, propertyInfo.isHasProperty);
    }
}

