/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.sharedontology.wizard;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.databoard.container.FormatHandler;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.primitiverequest.IsExternalEntity;
import org.simantics.db.common.primitiverequest.PossibleResource;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.db.layer0.migration.MigratedImportResult;
import org.simantics.db.layer0.migration.MigrationState;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.layer0.util.ModelDependenciesBean;
import org.simantics.db.layer0.util.ModelDependency;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.ImportResult;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.modeling.ui.Activator;

public class ModelImporter {
    public static MigratedImportResult doImport(final IProgressMonitor monitor, final File modelFile, final Session session, final Resource target, final boolean includeDependencies) throws Exception {
        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
        mon.beginTask("Loading model from disk", 1000);
        FormatHandler<MigratedImportResult> handler1 = new FormatHandler<MigratedImportResult>(){

            public Binding getBinding() {
                return TransferableGraph1.BINDING;
            }

            public MigratedImportResult process(DataContainer container) throws Exception {
                mon.worked(100);
                mon.setTaskName("Importing model into database");
                MigrationState state = MigrationUtils.newState();
                state.setProperty("updateDependencies", (Object)false);
                state.setProperty("modelFile", (Object)modelFile);
                state.setProperty("session", (Object)session);
                state.setProperty("progressMonitor", (Object)monitor);
                if (includeDependencies) {
                    try {
                        ModelDependenciesBean libraryDependenciesBean = ModelDependenciesBean.fromMigrationState((MigrationState)state);
                        if (libraryDependenciesBean != null) {
                            ModelDependency[] modelDependencyArray = libraryDependenciesBean.dependencies;
                            int n = libraryDependenciesBean.dependencies.length;
                            int n2 = 0;
                            while (n2 < n) {
                                boolean isExternalEntity;
                                ModelDependency dependency = modelDependencyArray[n2];
                                Resource existing = (Resource)session.sync((ReadInterface)new PossibleResource(dependency.uri));
                                boolean bl = isExternalEntity = existing != null && (Boolean)session.syncRequest((Read)new IsExternalEntity(existing)) != false;
                                if (existing == null || isExternalEntity) {
                                    MigrationUtils.importSharedOntology((Session)session, (TransferableGraph1)dependency.tg, (boolean)false);
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (AdaptException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", "Could not read model dependencies bean.", (Throwable)e));
                    }
                }
                MigrationUtils.importMigrated((IProgressMonitor)monitor, (Session)session, (File)modelFile, (MigrationState)state, (IImportAdvisor)new DefaultPasteImportAdvisor(target), (Resource)target);
                Collection resultRoots = (Collection)state.getProperty("currentRootResources");
                ImportResult result = (ImportResult)state.getProperty("importResult");
                return new MigratedImportResult(resultRoots, result);
            }
        };
        HashMap<String, 1> handlers = new HashMap<String, 1>();
        handlers.put(":1", handler1);
        handlers.put("model:1", handler1);
        MigratedImportResult result = (MigratedImportResult)DataContainers.readFile((File)modelFile, handlers);
        mon.setTaskName("Postprocessing");
        mon.subTask("");
        mon.newChild(50).done();
        return result;
    }
}

