/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.pdf;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.NameLabelMode;
import org.simantics.NameLabelUtil;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.requests.Node;
import org.simantics.modeling.ui.pdf.DiagramPrinter;
import org.simantics.modeling.ui.pdf.PDFExportPage;
import org.simantics.modeling.ui.pdf.PDFExportPlan;
import org.simantics.modeling.ui.pdf.PdfException;
import org.simantics.modeling.ui.utils.NoProjectPage;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.FileUtils;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.workbench.StringMemento;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFDiagramExportWizard
extends Wizard
implements IExportWizard {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDFDiagramExportWizard.class);
    private static final int MAX_RECENT_EXPORT_PATHS = 10;
    private static final String TAG_PATH = "path";
    private static final String ATTR_NAME = "name";
    Deque<String> recentExportPaths;
    boolean zoomToFit;
    boolean attachTG;
    boolean attachWiki;
    boolean addPageNumbers;
    PDFExportPlan exportPlan;

    private boolean readPreferences() {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
        String recentPathsPref = store.getString("diagram.export.pdf.path");
        this.recentExportPaths = this.decodePaths(recentPathsPref);
        this.zoomToFit = store.getBoolean("diagram.export.pdf.zoomToFit");
        this.attachTG = store.getBoolean("diagram.export.pdf.attachTG");
        this.attachWiki = store.getBoolean("diagram.export.pdf.attachWiki");
        this.addPageNumbers = store.getBoolean("diagram.export.pdf.addPageNumbers");
        return true;
    }

    private void writePreferences() throws IOException {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
        store.putValue("diagram.export.pdf.path", this.encodePaths(this.recentExportPaths));
        store.putValue("diagram.export.pdf.zoomToFit", String.valueOf(this.zoomToFit));
        store.putValue("diagram.export.pdf.attachTG", String.valueOf(this.attachTG));
        store.putValue("diagram.export.pdf.attachWiki", String.valueOf(this.attachWiki));
        store.putValue("diagram.export.pdf.addPageNumbers", String.valueOf(this.addPageNumbers));
        if (store.needsSaving()) {
            store.save();
        }
    }

    private Deque<String> decodePaths(String recentPathsPref) {
        LinkedList<String> result = new LinkedList<String>();
        try {
            StringMemento sm = new StringMemento(recentPathsPref);
            IMemento[] iMementoArray = sm.getChildren(TAG_PATH);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento m = iMementoArray[n2];
                String name = m.getString(ATTR_NAME);
                if (name != null && !name.isEmpty()) {
                    result.add(name);
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return result;
    }

    private String encodePaths(Deque<String> recentPaths) {
        StringMemento sm = new StringMemento();
        for (String path : recentPaths) {
            IMemento m = sm.createChild(TAG_PATH);
            m.putString(ATTR_NAME, path);
        }
        return sm.toString();
    }

    public PDFDiagramExportWizard() {
        this.setWindowTitle("Export Diagrams to PDF");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        if (this.exportPlan != null) {
            this.addPage((IWizardPage)new PDFExportPage(this.exportPlan));
        } else {
            this.addPage((IWizardPage)new NoProjectPage("Export Diagrams to PDF"));
        }
    }

    private NamedResource toNamedResource(ReadGraph graph, Resource r) throws DatabaseException {
        String name = NameLabelUtil.modalName((ReadGraph)graph, (Resource)r, (NameLabelMode)NameLabelMode.NAME_AND_LABEL);
        return new NamedResource(name, r);
    }

    public void init(IWorkbench workbench, final IStructuredSelection selection) {
        this.readPreferences();
        ISessionContext ctx = Simantics.getSessionContext();
        if (ctx == null) {
            return;
        }
        IProject project = (IProject)ctx.getHint(ProjectKeys.KEY_PROJECT);
        if (project == null) {
            return;
        }
        this.exportPlan = new PDFExportPlan(ctx, this.recentExportPaths);
        this.exportPlan.project = project;
        this.exportPlan.initialSelection = selection;
        this.exportPlan.fitContentToPageMargins = this.zoomToFit;
        this.exportPlan.attachTG = this.attachTG;
        this.exportPlan.attachWiki = this.attachWiki;
        this.exportPlan.addPageNumbers = this.addPageNumbers;
        try {
            this.exportPlan.sessionContext.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Resource indexRoot;
                    HashSet<Resource> processed = new HashSet<Resource>();
                    ArrayList<NamedResource> models = new ArrayList<NamedResource>();
                    Collection ontologies = (Collection)Simantics.applySCL((String)"Simantics/SharedOntologies", (String)"traverseSharedOntologies", (ReadGraph)graph, (Object[])new Object[]{graph.getRootLibrary()});
                    for (Resource root : ontologies) {
                        if (!processed.add(root)) continue;
                        models.add(PDFDiagramExportWizard.this.toNamedResource(graph, root));
                    }
                    for (Resource model : (Collection)graph.syncRequest((Read)new ObjectsWithType((Resource)PDFDiagramExportWizard.this.exportPlan.project.get(), Layer0.getInstance((ReadGraph)graph).ConsistsOf, SimulationResource.getInstance((ReadGraph)graph).Model))) {
                        if (!processed.add(model)) continue;
                        models.add(PDFDiagramExportWizard.this.toNamedResource(graph, model));
                    }
                    Collections.sort(models, AlphanumComparator.CASE_INSENSITIVE_COMPARATOR);
                    PDFDiagramExportWizard.this.exportPlan.selectableModels.addAll(models);
                    Resource selected = ResourceAdaptionUtils.toSingleResource((Object)selection.getFirstElement());
                    Resource resource = indexRoot = selected != null ? (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(selected)) : null;
                    if (indexRoot != null) {
                        PDFDiagramExportWizard.this.exportPlan.initialModelSelection = PDFDiagramExportWizard.this.exportPlan.selection = PDFDiagramExportWizard.this.toNamedResource(graph, indexRoot);
                    }
                    if (PDFDiagramExportWizard.this.exportPlan.selection == null && !PDFDiagramExportWizard.this.exportPlan.selectableModels.isEmpty()) {
                        PDFDiagramExportWizard.this.exportPlan.selection = PDFDiagramExportWizard.this.exportPlan.selectableModels.get(0);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to initialize diagram PDF export wizard input data.", (Throwable)e);
        }
    }

    public boolean performFinish() {
        if (this.exportPlan.exportLocation.exists()) {
            boolean confirmed = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Overwrite", (String)("Are you sure you want to overwrite " + this.exportPlan.exportLocation));
            if (!confirmed) {
                return false;
            }
            try {
                FileUtils.deleteAll((File)this.exportPlan.exportLocation);
            }
            catch (IOException e) {
                ExceptionUtils.logAndShowError((Throwable)e);
                return false;
            }
        }
        try {
            this.recentExportPaths.addFirst(this.exportPlan.exportLocation.getAbsolutePath());
            TreeSet<String> dups = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            Iterator<String> it = this.recentExportPaths.iterator();
            while (it.hasNext()) {
                String path = it.next();
                if (dups.add(path)) continue;
                it.remove();
            }
            if (this.recentExportPaths.size() > 10) {
                this.recentExportPaths.pollLast();
            }
            this.zoomToFit = this.exportPlan.fitContentToPageMargins;
            this.attachTG = this.exportPlan.attachTG;
            this.attachWiki = this.exportPlan.attachWiki;
            this.addPageNumbers = this.exportPlan.addPageNumbers;
            this.writePreferences();
        }
        catch (IOException e) {
            ErrorLogger.defaultLogError((String)"Failed to write preferences", (Throwable)e);
        }
        this.exportPlan.selectedNodes = this.exportPlan.nodes.depthFirstFlatten(new IFilter(){

            public boolean select(Object toTest) {
                Node n = (Node)toTest;
                return PDFDiagramExportWizard.this.exportPlan.selectedNodeSet.contains(n) && n.getDiagramResource() != null;
            }
        }, Node.CASE_INSENSITIVE_COMPARATOR);
        long start = System.currentTimeMillis();
        try {
            this.getContainer().run(true, true, monitor -> {
                try {
                    try {
                        DiagramPrinter.printToPdf(monitor, this.exportPlan, this.exportPlan.exportLocation.toString(), this.exportPlan.selectedNodes);
                    }
                    catch (PdfException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            ExceptionUtils.logAndShowError((Throwable)t);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        long end = System.currentTimeMillis();
        LOGGER.info("PDF export took " + (double)(end - start) * 0.001 + " seconds.");
        return true;
    }
}

