/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.awt.Color;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.diagram.adapter.DefaultConnectionClassFactory;
import org.simantics.diagram.adapter.FlagClassFactory;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.diagram.adapter.IDiagramLoader;
import org.simantics.diagram.handler.SimpleElementTransformHandler;
import org.simantics.diagram.layer.ILayersViewPage;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.DiagramParticipant;
import org.simantics.g2d.diagram.participant.ElementInteractor;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.TerminalPainter;
import org.simantics.g2d.diagram.participant.ZOrderHandler;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.element.ElementClassProviders;
import org.simantics.g2d.element.ElementClasses;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.multileveldiagram.TransitionFunction;
import org.simantics.g2d.multileveldiagram.ZoomTransitionParticipant;
import org.simantics.g2d.participant.BackgroundPainter;
import org.simantics.g2d.participant.CanvasBoundsParticipant;
import org.simantics.g2d.participant.CanvasGrab;
import org.simantics.g2d.participant.GridPainter;
import org.simantics.g2d.participant.KeyToCommand;
import org.simantics.g2d.participant.KeyUtil;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.participant.MultitouchPanZoomRotateInteractor;
import org.simantics.g2d.participant.Notifications;
import org.simantics.g2d.participant.PageBorderParticipant;
import org.simantics.g2d.participant.PanZoomRotateHandler;
import org.simantics.g2d.participant.PointerPainter;
import org.simantics.g2d.participant.RulerPainter;
import org.simantics.g2d.participant.SymbolUtil;
import org.simantics.g2d.participant.TimeParticipant;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.participant.ZoomToAreaHandler;
import org.simantics.g2d.utils.CanvasUtils;
import org.simantics.layer0.utils.triggers.IActivation;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.mapping.ModelingSynchronizationHints;
import org.simantics.modeling.ui.diagramEditor.DiagramLayersPage;
import org.simantics.modeling.ui.diagramEditor.DiagramOutlinePage;
import org.simantics.modeling.ui.diagramEditor.PopulateElementDropParticipant;
import org.simantics.modeling.ui.diagramEditor.PopulateElementMonitorDropParticipant;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.CommandKeyBinding;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.ui.dnd.ResourceTransferData;
import org.simantics.ui.dnd.ResourceTransferUtils;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.IResourceEditorInput2;
import org.simantics.ui.workbench.IResourceEditorPart2;
import org.simantics.ui.workbench.ResourceEditorSupport;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.page.PageOrientation;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;

public class WikiDiagramViewer
extends EditorPart
implements IResourceEditorPart2 {
    protected boolean disposed = false;
    protected IDiagram sourceDiagram;
    protected ICanvasContext canvasContext;
    protected ResourceEditorSupport support;
    protected ISessionContextProvider sessionContextProvider;
    protected ISessionContext sessionContext;
    protected GraphToDiagramSynchronizer synchronizer;
    protected IActivation activation;
    protected ResourceArray structuralPath = new ResourceArray(new Resource[0]);
    protected IContextActivation contextActivation;
    protected IExperiment experiment;
    protected String layer = null;
    private boolean firstFocus = true;

    protected void addDropParticipants(ICanvasContext ctx) {
        ctx.add((Object)new PopulateElementDropParticipant(this.synchronizer));
        ctx.add((Object)new PopulateElementMonitorDropParticipant(this.synchronizer, 0.5, 0.5));
    }

    protected void addKeyBindingParticipants(CanvasContext ctx) {
        ctx.add((Object)new KeyToCommand(CommandKeyBinding.DEFAULT_BINDINGS));
    }

    public void setExperiment(IExperiment experiment) {
        this.sourceDiagram.setHint(DiagramModelHints.KEY_ACTIVE_EXPERIMENT, (Object)experiment);
    }

    public void init(ResourceArray structuralPath, String layer, IExperiment experiment) {
        this.experiment = experiment;
        this.layer = layer;
        this.structuralPath = structuralPath;
        this.sessionContextProvider = Simantics.getSessionContextProvider();
        this.sessionContext = this.sessionContextProvider.getSessionContext();
        this.canvasContext = this.createViewerCanvas();
        try {
            this.sourceDiagram = this.loadDiagram(structuralPath, experiment);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.onCreated();
    }

    public void updateDiagram(ResourceArray structuralPath) {
        this.canvasContext = this.createViewerCanvas();
        try {
            HintContext hints = new HintContext();
            hints.setHint(DiagramModelHints.KEY_ACTIVE_EXPERIMENT, (Object)this.experiment);
            if (this.layer != null) {
                System.out.println("using layer '" + this.layer + "'");
                hints.setHint(DiagramHints.KEY_FIXED_LAYERS, (Object)new String[]{this.layer});
            }
            this.sourceDiagram = (IDiagram)this.sessionContext.getSession().syncRequest(DiagramRequests.loadDiagram((IProgressMonitor)new NullProgressMonitor(), (Resource)this.getResourceInput2().getModel(null), (Resource)structuralPath.resources[0], null, (ResourceArray)structuralPath.removeFromBeginning(0), (IDiagramLoader)this.synchronizer, (IHintObservable)hints));
            this.canvasContext.getDefaultHintContext().setHint(DiagramHints.KEY_DIAGRAM, (Object)this.sourceDiagram);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    void scheduleZoomToFit() {
        if (this.sourceDiagram == null) {
            throw new IllegalStateException("source diagram is null");
        }
        this.sourceDiagram.setHint(Hints.KEY_DISABLE_PAINTING, (Object)Boolean.TRUE);
        this.sourceDiagram.setHint(DiagramHints.KEY_INITIAL_ZOOM_TO_FIT, (Object)Boolean.TRUE);
        this.sourceDiagram.removeHint(Hints.KEY_DISABLE_PAINTING);
        Boolean zoomToFit = (Boolean)this.sourceDiagram.removeHint(DiagramHints.KEY_INITIAL_ZOOM_TO_FIT);
        if (zoomToFit != null && zoomToFit.booleanValue()) {
            CanvasUtils.sendCommand((ICanvasContext)this.canvasContext, (Command)Commands.ZOOM_TO_FIT);
        }
        this.canvasContext.getContentContext().setDirty();
    }

    protected IDiagram loadDiagram(ResourceArray structuralPath, IExperiment experiment) throws DatabaseException {
        HintContext hints = new HintContext();
        if (experiment != null) {
            hints.setHint(DiagramModelHints.KEY_ACTIVE_EXPERIMENT, (Object)experiment);
        }
        if (this.layer != null) {
            System.out.println("using layer '" + this.layer + "'");
            hints.setHint(DiagramHints.KEY_FIXED_LAYERS, (Object)new String[]{this.layer});
        }
        IDiagram d = (IDiagram)this.sessionContext.getSession().syncRequest(DiagramRequests.loadDiagram((IProgressMonitor)new NullProgressMonitor(), (Resource)this.getResourceInput2().getModel(null), (Resource)structuralPath.resources[0], null, (ResourceArray)structuralPath.removeFromBeginning(0), (IDiagramLoader)this.synchronizer, (IHintObservable)hints));
        this.canvasContext.getDefaultHintContext().setHint(DiagramHints.KEY_DIAGRAM, (Object)d);
        return d;
    }

    protected GraphToDiagramSynchronizer createSynchronizer(final ICanvasContext ctx, ISessionContext sessionContext) {
        try {
            return (GraphToDiagramSynchronizer)sessionContext.getSession().syncRequest((Read)new Read<GraphToDiagramSynchronizer>(){

                public GraphToDiagramSynchronizer perform(ReadGraph graph) throws DatabaseException {
                    DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
                    GraphToDiagramSynchronizer sync = new GraphToDiagramSynchronizer((RequestProcessor)graph, ctx, ElementClassProviders.mappedProvider((Object[])new Object[]{ElementClasses.CONNECTION, DefaultConnectionClassFactory.CLASS.newClassWith(new ElementHandler[]{new StaticObjectAdapter((Object)dr.Connection)}), ElementClasses.FLAG, FlagClassFactory.createFlagClass((Resource)dr.Flag, (Resource)dr.Flag_Terminal)}));
                    sync.set(ModelingSynchronizationHints.MODELING_RESOURCE, (Object)ModelingResources.getInstance((ReadGraph)graph));
                    return sync;
                }
            });
        }
        catch (DatabaseException e) {
            throw new UnsupportedOperationException("Failed to initialize data model synchronizer", e);
        }
    }

    public ICanvasContext createViewerCanvas() {
        IThreadWorkQueue thread = AWTThread.getThreadAccess();
        CanvasContext ctx = new CanvasContext(thread);
        IHintContext h = ctx.getDefaultHintContext();
        this.synchronizer = this.createSynchronizer((ICanvasContext)ctx, this.sessionContext);
        this.canvasContext.add((Object)new PanZoomRotateHandler());
        ctx.add((Object)new TransformUtil());
        ctx.add((Object)new MouseUtil());
        ctx.add((Object)new KeyUtil());
        ctx.add((Object)new CanvasGrab());
        ctx.add((Object)new SymbolUtil());
        ctx.add((Object)new TimeParticipant());
        ctx.add((Object)new CanvasBoundsParticipant());
        ctx.add((Object)new Notifications());
        h.setHint(PointerPainter.KEY_PAINT_POINTER, (Object)true);
        ctx.add((Object)new MultitouchPanZoomRotateInteractor());
        ctx.add((Object)new ZoomToAreaHandler());
        ctx.add((Object)new SimpleElementTransformHandler());
        this.addKeyBindingParticipants(ctx);
        ctx.add((Object)new GridPainter());
        ctx.add((Object)new RulerPainter());
        ctx.add((Object)new BackgroundPainter());
        ctx.add((Object)new PageBorderParticipant());
        h.setHint(Hints.KEY_GRID_COLOR, (Object)new Color(0.95f, 0.95f, 0.95f));
        h.setHint(Hints.KEY_BACKGROUND_COLOR, (Object)Color.WHITE);
        h.setHint(RulerPainter.KEY_RULER_BACKGROUND_COLOR, (Object)new Color(0.9f, 0.9f, 0.9f, 0.75f));
        h.setHint(RulerPainter.KEY_RULER_TEXT_COLOR, (Object)Color.BLACK);
        ctx.add((Object)new PointerInteractor(true, true, true, false, true, false, this.synchronizer.getElementClassProvider(), null));
        ctx.add((Object)new ElementInteractor());
        ctx.add((Object)new Selection());
        ctx.add((Object)new DiagramParticipant());
        ctx.add((Object)new ElementPainter());
        ctx.add((Object)new TerminalPainter(true, true, false, true));
        ctx.add((Object)new ZOrderHandler());
        ctx.add((Object)new ZoomTransitionParticipant(TransitionFunction.SIGMOID));
        this.addDropParticipants((ICanvasContext)ctx);
        h.setHint(Hints.KEY_TOOL, (Object)Hints.POINTERTOOL);
        h.setHint(PanZoomRotateHandler.KEY_ZOOM_IN_LIMIT, (Object)1000.0);
        h.setHint(PanZoomRotateHandler.KEY_ZOOM_OUT_LIMIT, (Object)10.0);
        PageDesc pageDesc = PageDesc.DEFAULT.withOrientation(PageOrientation.Landscape);
        h.setHint(Hints.KEY_PAGE_DESC, (Object)pageDesc);
        ctx.assertParticipantDependencies();
        return ctx;
    }

    public void setFocus() {
        if (this.firstFocus) {
            this.firstFocus = false;
            this.firstTimeSetFocus();
        }
    }

    protected void firstTimeSetFocus() {
        this.scheduleZoomToFit();
    }

    public void dispose() {
        System.out.println("RemoteDiagramViewer.dispose()");
        if (this.getSite() != null) {
            IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
            contextService.deactivateContext(this.contextActivation);
        }
        this.disposed = true;
        if (this.activation != null) {
            this.activation.deactivate();
            this.activation = null;
        }
        if (this.synchronizer != null) {
            this.synchronizer.dispose();
            this.synchronizer = null;
        }
        if (this.sourceDiagram != null) {
            this.sourceDiagram.dispose();
            this.sourceDiagram = null;
        }
        if (this.support != null) {
            this.support.dispose();
            this.support = null;
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IResourceEditorInput)) {
            throw new PartInitException("Invalid input: must be IResourceEditorInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.support = new ResourceEditorSupport((IEditorPart)this);
        this.setPartName(this.getEditorInput().getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public static ResourceArray[] decodeToResources(Session session, Transferable tr) {
        try {
            SerialisationSupport support = (SerialisationSupport)session.getService(SerialisationSupport.class);
            ResourceTransferData data = ResourceTransferUtils.readAwtTransferable((SerialisationSupport)support, (Transferable)tr);
            if ("property".equals(data.getPurpose())) {
                return data.toResourceArrayArray();
            }
        }
        catch (UnsupportedFlavorException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            return new DiagramOutlinePage(this.sessionContextProvider, this.getResourceInput2());
        }
        if (adapter == ILayersViewPage.class) {
            return new DiagramLayersPage(this.sourceDiagram, this.canvasContext);
        }
        if (adapter == ICanvasContext.class) {
            return this.canvasContext;
        }
        if (adapter == IDiagram.class) {
            return this.sourceDiagram;
        }
        if (adapter == Session.class) {
            return this.sessionContext.getSession();
        }
        return super.getAdapter(adapter);
    }

    public ICanvasContext getCanvasContext() {
        return this.canvasContext;
    }

    protected void onCreated() {
    }

    public void createPartControl(Composite parent) {
    }

    public IResourceEditorInput2 getResourceInput2() {
        return null;
    }

    public IResourceEditorInput getResourceInput() {
        return null;
    }
}

