/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import gnu.trove.set.hash.THashSet;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.dnd.DnDHints;
import org.simantics.g2d.dnd.ElementClassDragItem;
import org.simantics.g2d.dnd.IDnDContext;
import org.simantics.g2d.dnd.IDropTargetParticipant;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.utils.Alignment;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.PropertyVariables;
import org.simantics.modeling.PropertyVariablesImpl;
import org.simantics.modeling.ui.diagram.monitor.MonitorClassFactory2;
import org.simantics.modeling.ui.diagramEditor.PopulateElementDropParticipant;
import org.simantics.modeling.ui.diagramEditor.WSEDragItem;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalObjectTransferable;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.utils.datastructures.Triple;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateElementMonitorDropParticipant
extends PopulateElementDropParticipant
implements IDropTargetParticipant {
    private static final Logger LOGGER = LoggerFactory.getLogger(PopulateElementMonitorDropParticipant.class);
    private static final boolean DEBUG = false;
    double scaleX;
    double scaleY;
    String typeURI;

    public PopulateElementMonitorDropParticipant(GraphToDiagramSynchronizer synchronizer, double scaleX, double scaleY) {
        super(synchronizer);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.typeURI = "http://www.simantics.org/Diagram-2.2/Monitor";
    }

    public PopulateElementMonitorDropParticipant(GraphToDiagramSynchronizer synchronizer, String typeURI, double scaleX, double scaleY) {
        super(synchronizer);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.typeURI = typeURI;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde, IDnDContext dp) {
        Transferable tr = dtde.getTransferable();
        if (tr.isDataFlavorSupported(LocalObjectTransferable.FLAVOR)) {
            try {
                Object obj = tr.getTransferData(LocalObjectTransferable.FLAVOR);
                if (!(obj instanceof IStructuredSelection)) {
                    obj = LocalObjectTransfer.getTransfer().getObject();
                }
                if (obj instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)obj;
                    for (WorkbenchSelectionElement wse : WorkbenchSelectionUtils.getWorkbenchSelectionElements((ISelection)sel)) {
                        dp.add((Object)new WSEDragItem(wse));
                    }
                    Session session = this.synchronizer.getSession();
                    List<Variable> properties = this.resolveVariables((RequestProcessor)session, (IStructuredSelection)obj);
                    if (properties.isEmpty()) {
                        return;
                    }
                    List items = (List)session.syncRequest((Read)new ResolveItems(properties));
                    for (ElementClassDragItem item : items) {
                        dp.add((Object)item);
                    }
                    dp.getHints().setHint(DnDHints.KEY_DND_GRID_COLUMNS, (Object)1);
                }
            }
            catch (UnsupportedFlavorException | IOException | DatabaseException e) {
                LOGGER.error("dragEnter failed", e);
            }
        }
        dtde.acceptDrag(1);
    }

    public void setHints(IHintContext context) {
    }

    protected List<Variable> resolveVariables(RequestProcessor processor, IStructuredSelection sel) throws DatabaseException {
        if (sel.isEmpty()) {
            return Collections.emptyList();
        }
        Variable property = WorkbenchSelectionUtils.getPossibleVariableFromSelection((RequestProcessor)processor, (Object)sel);
        if (property != null) {
            return Collections.singletonList(property);
        }
        property = (Variable)ISelectionUtils.getSinglePossibleKey((Object)sel, (IHintContext.Key)SelectionHints.KEY_SELECTION_PROPERTY, Variable.class);
        if (property != null) {
            return Collections.singletonList(property);
        }
        final List vars = ISelectionUtils.getPossibleKeys((Object)sel, (IHintContext.Key)SelectionHints.KEY_MAIN, PropertyVariables.class);
        if (!vars.isEmpty()) {
            return (List)processor.syncRequest((Read)new UniqueRead<List<Variable>>(){

                public List<Variable> perform(ReadGraph graph) throws DatabaseException {
                    List vs = PropertyVariablesImpl.resolve((ReadGraph)graph, (List)vars);
                    ArrayList<Variable> result = new ArrayList<Variable>(vs.size());
                    for (PropertyVariables v : vs) {
                        result.add(v.getVisualVariable());
                    }
                    return result;
                }
            });
        }
        return Collections.emptyList();
    }

    private static Resource findCommonParent(ReadGraph graph, Resource a, Resource b) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        THashSet set = new THashSet();
        while (true) {
            if (a != null) {
                if (!set.add((Object)a)) {
                    return a;
                }
                a = graph.getPossibleObject(a, L0.PartOf);
            } else if (b == null) {
                return graph.getRootLibrary();
            }
            if (b == null) continue;
            if (!set.add((Object)b)) {
                return b;
            }
            b = graph.getPossibleObject(a, L0.PartOf);
        }
    }

    @Override
    public double getPriority() {
        return 9.0;
    }

    protected class ResolveItems
    extends UnaryRead<List<Variable>, List<ElementClassDragItem>> {
        public ResolveItems(List<Variable> parameter) {
            super(parameter);
        }

        public List<ElementClassDragItem> perform(ReadGraph graph) throws DatabaseException {
            ArrayList<ElementClassDragItem> result = new ArrayList<ElementClassDragItem>(((List)this.parameter).size());
            for (Variable property : (List)this.parameter) {
                result.addAll(this.resolve(graph, property));
            }
            return result;
        }

        public List<ElementClassDragItem> resolve(ReadGraph graph, Variable parameter) throws DatabaseException {
            Triple<Variable, Resource, IElement> match = this.findElementInDiagram(graph, parameter, false);
            if (match == null) {
                return Collections.emptyList();
            }
            if (match.third == null) {
                Resource diagram = (Resource)PopulateElementMonitorDropParticipant.this.synchronizer.getDiagram().getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
                Resource commonParent = PopulateElementMonitorDropParticipant.findCommonParent(graph, diagram, (Resource)match.second);
                StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                if (!graph.isInstanceOf(commonParent, STR.Composite)) {
                    return Collections.emptyList();
                }
            }
            String rvi = Variables.getRVI((ReadGraph)graph, (Variable)((Variable)match.first), (Variable)parameter);
            Resource type = graph.getResource(PopulateElementMonitorDropParticipant.this.typeURI);
            ElementClassDragItem item = new ElementClassDragItem(MonitorClassFactory2.createMonitorClass(type, (IElement)match.third, new HashMap<String, String>(), match.second, rvi, PopulateElementMonitorDropParticipant.this.scaleX, PopulateElementMonitorDropParticipant.this.scaleY));
            item.getHintContext().setHint(ElementHints.KEY_HORIZONTAL_ALIGN, (Object)Alignment.LEADING);
            if (match.third != null) {
                item.getHintContext().setHint(ElementHints.KEY_PARENT_ELEMENT, match.third);
            }
            AffineTransform initialTr = AffineTransform.getScaleInstance(PopulateElementMonitorDropParticipant.this.scaleX, PopulateElementMonitorDropParticipant.this.scaleY);
            item.getHintContext().setHint(ElementHints.KEY_TRANSFORM, (Object)initialTr);
            PopulateElementMonitorDropParticipant.this.setHints(item.getHintContext());
            return Collections.singletonList(item);
        }

        private Triple<Variable, Resource, IElement> findElementInDiagram(ReadGraph graph, Variable property, boolean propertyRoleFound) throws DatabaseException {
            Resource elementResource;
            Resource represents;
            if (property == null) {
                return null;
            }
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            Resource diagram = (Resource)PopulateElementMonitorDropParticipant.this.synchronizer.getDiagram().getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
            if (!propertyRoleFound) {
                Variables.Role role = property.getPossibleRole(graph);
                boolean bl = propertyRoleFound = role == Variables.Role.PROPERTY;
            }
            if ((represents = property.getPossibleRepresents(graph)) != null && (elementResource = graph.getPossibleObject(represents, MOD.ComponentToElement)) != null && propertyRoleFound) {
                Resource elementDiagram = OrderedSetUtils.getSingleOwnerList((ReadGraph)graph, (Resource)elementResource, (Resource)DIA.Diagram);
                if (diagram.equals(elementDiagram)) {
                    IElement tailNodeElement;
                    Resource tailNode;
                    DataElementMap map = (DataElementMap)PopulateElementMonitorDropParticipant.this.synchronizer.getDiagram().getDiagramClass().getSingleItem(DataElementMap.class);
                    IElement parentElement = map.getElement(PopulateElementMonitorDropParticipant.this.synchronizer.getDiagram(), (Object)elementResource);
                    if (graph.isInstanceOf(elementResource, DIA.Connection) && (tailNode = ConnectionUtil.getConnectionTailNode((ReadGraph)graph, (Resource)elementResource)) != null && (tailNodeElement = map.getElement(PopulateElementMonitorDropParticipant.this.synchronizer.getDiagram(), (Object)tailNode)) != null) {
                        parentElement = tailNodeElement;
                    }
                    return Triple.make((Object)property, (Object)represents, (Object)parentElement);
                }
                return Triple.make((Object)property, (Object)represents, null);
            }
            return this.findElementInDiagram(graph, property.browsePossible(graph, "."), propertyRoleFound);
        }
    }
}

