/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.diagramEditor.TerminalInformer;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.queries.Terminal;

public final class DefaultTerminalNamingStrategy
implements TerminalInformer.TerminalNamingStrategy {
    @Override
    public String getName(ReadGraph graph, TerminalUtil.TerminalInfo info) throws DatabaseException {
        Terminal t = (Terminal)graph.syncRequest((Read)new ResolveTerminal(info));
        if (t == null) {
            return "Could not resolve component terminal";
        }
        return (String)graph.syncRequest((Read)new TerminalMessage(t));
    }

    public static class ResolveTerminal
    extends UnaryRead<TerminalUtil.TerminalInfo, Terminal> {
        public ResolveTerminal(TerminalUtil.TerminalInfo parameter) {
            super((Object)parameter);
        }

        public Terminal perform(ReadGraph graph) throws DatabaseException {
            ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
            Object elementObject = ElementUtils.getObject((IElement)((TerminalUtil.TerminalInfo)this.parameter).e);
            if (!(elementObject instanceof Resource)) {
                return null;
            }
            Resource element = (Resource)elementObject;
            Resource diagramBindingRelation = DiagramGraphUtil.getConnectionPointOfTerminal((ReadGraph)graph, (Topology.Terminal)((TerminalUtil.TerminalInfo)this.parameter).t);
            if (diagramBindingRelation == null) {
                return null;
            }
            Resource component = graph.getPossibleObject(element, mr.ElementToComponent);
            Resource connectionRelation = graph.getPossibleObject(diagramBindingRelation, mr.DiagramConnectionRelationToConnectionRelation);
            if (component == null || connectionRelation == null) {
                return null;
            }
            return new Terminal(component, connectionRelation);
        }
    }

    static class TerminalMessage
    extends UnaryRead<Terminal, String> {
        public TerminalMessage(Terminal terminal) {
            super((Object)terminal);
        }

        public String perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
            String name = this.getStringPropertyValue(graph, ((Terminal)this.parameter).getRelation(), L0.HasName);
            String label = this.getStringPropertyValue(graph, ((Terminal)this.parameter).getRelation(), L0.HasLabel);
            String componentName = NameUtils.getSafeName((ReadGraph)graph, (Resource)((Terminal)this.parameter).getComponent());
            Resource componentType = graph.getPossibleType(((Terminal)this.parameter).getComponent(), STR.Component);
            String componentTypeName = componentType != null ? this.getStringPropertyValue(graph, componentType, L0.HasLabel) : null;
            StringBuilder sb = new StringBuilder();
            if (name.equals(label)) {
                sb.append(name);
            } else {
                sb.append("(").append(name).append(") ").append(label);
            }
            sb.append(" [").append(componentName);
            if (componentTypeName != null) {
                sb.append(" : ").append(componentTypeName);
            }
            sb.append("]");
            return sb.toString();
        }

        private String getStringPropertyValue(ReadGraph graph, Resource entity, Resource property) throws DatabaseException {
            String name = (String)graph.getPossibleRelatedValue2(entity, property);
            return name != null ? name : NameUtils.getSafeName((ReadGraph)graph, (Resource)entity);
        }
    }
}

