/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.ui.editor.SCLTextEditorNew;
import org.simantics.scl.ui.editor.TextAndErrors;
import org.simantics.structural2.scl.procedural.CompileProceduralComponentTypeRequest;
import org.simantics.structural2.scl.procedural.ProceduralComponentTypeCompilationException;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.TitleUpdater;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.SWTUtils;

public class SCLEditorBase
extends EditorPart
implements IExecutableExtension {
    Resource inputResource;
    SCLTextEditorNew editor;
    String originalText;

    protected TextAndErrors getTextAndErrors(ReadGraph graph, Resource resource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String text = (String)graph.getValue(resource, (Binding)Bindings.STRING);
        Resource componentType = graph.getPossibleObject(this.inputResource, L0.PropertyOf);
        CompilationError[] errors = CompilationError.EMPTY_ARRAY;
        if (componentType != null) {
            try {
                graph.syncRequest((Read)new CompileProceduralComponentTypeRequest(componentType));
            }
            catch (ProceduralComponentTypeCompilationException e) {
                errors = e.errors;
            }
        }
        return new TextAndErrors(text, errors);
    }

    public void createPartControl(Composite parent) {
        this.editor = new SCLTextEditorNew(parent, 0);
        Simantics.getSession().asyncRequest((Read)new ResourceRead<TextAndErrors>(this.inputResource){

            public TextAndErrors perform(ReadGraph graph) throws DatabaseException {
                return SCLEditorBase.this.getTextAndErrors(graph, SCLEditorBase.this.inputResource);
            }
        }, (Listener)new Listener<TextAndErrors>(){

            public void execute(final TextAndErrors textAndErrors) {
                SWTUtils.asyncExec((Widget)SCLEditorBase.this.editor, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if ((this).SCLEditorBase.this.editor.isDisposed()) {
                            return;
                        }
                        (this).SCLEditorBase.this.originalText = textAndErrors.text;
                        boolean textDiffers = !(this).SCLEditorBase.this.originalText.equals((this).SCLEditorBase.this.editor.getContent());
                        (this).SCLEditorBase.this.editor.setContent(textDiffers ? (this).SCLEditorBase.this.originalText : null, textAndErrors.errors);
                        SCLEditorBase.this.firePropertyChange(257);
                        if (textDiffers) {
                            (this).SCLEditorBase.this.editor.getUndoManager().reset();
                        }
                    }
                });
            }

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((Throwable)t);
            }

            public boolean isDisposed() {
                return SCLEditorBase.this.editor.isDisposed();
            }
        });
        this.editor.viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                SCLEditorBase.this.firePropertyChange(257);
            }
        });
    }

    public void setFocus() {
        this.editor.setFocus();
    }

    protected void save(WriteGraph graph, Resource resource, String text) throws DatabaseException {
        graph.claimValue(resource, (Object)text);
    }

    public void doSave(IProgressMonitor monitor) {
        this.originalText = this.editor.getContent();
        this.firePropertyChange(257);
        try {
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    graph.markUndoPoint();
                    SCLEditorBase.this.save(graph, SCLEditorBase.this.inputResource, SCLEditorBase.this.originalText);
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Saved SCL Module " + graph.getRelatedValue2(SCLEditorBase.this.inputResource, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING)));
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
    }

    protected String computeTitle(ReadGraph graph, Resource inputResource) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource parent = graph.getPossibleObject(inputResource, L0.PropertyOf);
        if (parent == null) {
            return "No parent";
        }
        return graph.getPossibleRelatedValue(parent, L0.HasName) + " (Code)";
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.inputResource = ((IResourceEditorInput)input).getResource();
        Simantics.getSession().asyncRequest((Read)new UniqueRead<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                return SCLEditorBase.this.computeTitle(graph, SCLEditorBase.this.inputResource);
            }
        }, (Listener)new TitleUpdater(site.getShell().getDisplay(), partName -> {
            this.setPartName((String)partName);
            this.setTitleToolTip((String)partName);
        }, () -> this.editor != null && this.editor.isDisposed()));
    }

    public boolean isDirty() {
        return !this.editor.getContent().equals(this.originalText);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

