package org.simantics.modeling.tests.commands;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.testing.common.CommandSequenceEnvironment;
import org.simantics.db.testing.common.WriteCommand;
import org.simantics.utils.Development;

public class SetDevelopmentProperty extends WriteCommand<CommandSequenceEnvironment> {

	transient private String key;
	transient private Object value;
	transient private Binding binding;
	
	public SetDevelopmentProperty(String key, Object value, Binding binding) {
		this.key = key;
		this.value = value;
		this.binding = binding;
	}
	
	@Override
	public void run(CommandSequenceEnvironment environment) throws Exception {

		Development.setProperty(key, value, binding);
		
	}

}