package org.simantics.modeling.tests.commands;

import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.Model;
import org.simantics.db.testing.common.CommandSequenceEnvironment;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.scenegraph.ICanvasSceneGraphProvider;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.triggers.IActivation;
import org.simantics.layer0.utils.triggers.IActivationManager;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.tests.traits.SingleResourceTrait;
import org.simantics.modeling.tests.traits.SingleResourceTraitImpl;
import org.simantics.utils.threads.WorkerThread;

public class LoadDiagram extends ResourceWriteCommand<CommandSequenceEnvironment> implements SingleResourceTrait {
    private static final boolean DEBUG = true;
	private SingleResourceTrait diagram;

	transient private ICanvasSceneGraphProvider provider;
	transient private CanvasContext ctx;
	transient private IActivation activation;
	transient private WorkerThread workerThread;
	
	public LoadDiagram(SingleResourceTrait diagram) {
		this.diagram = diagram;
	}
	
	public LoadDiagram(Resource diagram) {
		this(new SingleResourceTraitImpl(diagram));
	}
	
	@Override
	public Resource runResource(CommandSequenceEnvironment environment) throws DatabaseException {
		
        try {
        	
        	Resource model = Simantics.sync(new Model(diagram.getResource()));
        	String diagramName = Simantics.sync(new ResourceRead<String>(diagram.getResource()) {

				@Override
				public String perform(ReadGraph graph) throws DatabaseException {
					Layer0 L0 = Layer0.getInstance(graph);
					ModelingResources MOD = ModelingResources.getInstance(graph);
					Resource composite = graph.getPossibleObject(resource, MOD.DiagramToComposite);
					return graph.getPossibleRelatedValue(composite, L0.HasName, Bindings.STRING);
				}
        		
        	});
        	if (DEBUG)
        	    System.out.println("DEBUG: load " + diagramName);
            workerThread = new WorkerThread("Load diagram");
            workerThread.start();
        	// Load diagram
            ctx = new CanvasContext(workerThread);
			provider = DiagramNodeUtil.loadSceneGraphProvider(ctx, model, diagram.getResource(), "/" + diagramName);
			// Activate mapping
	        IActivationManager activationManager = Simantics.getSession().peekService(IActivationManager.class);
	        if (activationManager != null) {
	            activation = activationManager.activate(diagram.getResource());
	        }

		} catch (InterruptedException e) {
			throw new DatabaseException(e);
		}
        
        return diagram.getResource();
        
	}
	
	public ICanvasSceneGraphProvider getProvider() {
		return provider;
	}
	
	public IActivation getActivation() {
		return activation;
	}
	
	public CanvasContext getContext() {
		return ctx;
	}
	
	public WorkerThread getWorkerThread() {
		return workerThread;
	}
	
	public IDiagram getDiagram() {
		return ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
	}

}