package org.simantics.modeling.tests.commands;

import org.simantics.Simantics;
import org.simantics.db.testing.common.Command;
import org.simantics.db.testing.common.CommandInvoker;
import org.simantics.modeling.requests.CollectionRequest;
import org.simantics.modeling.requests.CollectionResult;
import org.simantics.modeling.requests.Node;
import org.simantics.modeling.tests.cases.ModelingCommandSequenceTest;
import org.simantics.modeling.tests.traits.SingleModelTrait;
import org.simantics.modeling.tests.traits.SingleResourceTrait;
import org.simantics.modeling.tests.traits.SingleResourceTraitImpl;
import org.simantics.utils.page.PageDesc;

public class ForAllDiagrams extends Command<ModelingCommandSequenceTest> {

	transient private SingleModelTrait model;
	transient private CommandInvoker<SingleResourceTrait>[] invokers;
	
	public ForAllDiagrams(SingleModelTrait model, CommandInvoker<SingleResourceTrait> ... invokers) {
		this.model = model;
		this.invokers = invokers;
	}
	
	@Override
	public void run(ModelingCommandSequenceTest environment) throws Exception {
	
		final CollectionResult result = Simantics.getSession().syncRequest(new CollectionRequest(null, PageDesc.DEFAULT, model.getResource()));
		for(Node diagramNode : result.diagramList) {
			for(CommandInvoker<SingleResourceTrait> invoker : invokers)
				invoker.invoke(environment, new SingleResourceTraitImpl(diagramNode.getDiagramResource()));
		}
		
	}

}
