package org.simantics.modeling.tests.commands;

import junit.framework.Assert;

import org.simantics.db.testing.common.WriteCommand;
import org.simantics.modeling.tests.cases.ModelingCommandSequenceTest;

public class AssertMemoryConsumption extends WriteCommand<ModelingCommandSequenceTest> {

	private int expected;
	
	public AssertMemoryConsumption(int expected) {
		this.expected = expected;
	}

	@Override
	public void run(ModelingCommandSequenceTest environment) throws Exception {
		Assert.assertTrue(getUsedMemory() < expected);
	}
	
	private long getUsedMemory() {
		
    	System.gc();
    	System.gc();
    	System.gc();
    	Runtime runtime = Runtime.getRuntime();
    	return runtime.totalMemory() - runtime.freeMemory();
		
	}

}