package org.simantics.modeling.tests.commands;

import junit.framework.Assert;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.testing.common.WriteCommand;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.tests.cases.ModelingCommandSequenceTest;


public class AssertMappedConnection extends WriteCommand<ModelingCommandSequenceTest> {

	private Connect connect;
	
	public AssertMappedConnection(Connect connect) {
		this.connect = connect;
	}
	
	@Override
	protected void run(WriteGraph graph, ModelingCommandSequenceTest environment) throws DatabaseException {
		
        Resource element = connect.getResource();
        Resource component = graph.getPossibleObject(element, ModelingResources.getInstance(graph).ElementToComponent);
        Assert.assertNotNull(component);
        
	}

}