/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.management.ISessionContext;
import org.simantics.modeling.template2d.DiagramTemplates;
import org.simantics.modeling.template2d.ui.wizard.DrawingTemplateImportPage;
import org.simantics.modeling.template2d.ui.wizard.ImportPlan;
import org.simantics.modeling.template2d.ui.wizard.Preferences;
import org.simantics.modeling.ui.utils.NoProjectPage;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;

public class DrawingTemplateImportWizard
extends Wizard
implements IImportWizard {
    private static final int MAX_RECENT_IMPORT_PATHS = 10;
    ImportPlan importModel;

    private boolean readPreferences(IStructuredSelection selection) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.template2d.ui");
        String recentPathsPref = store.getString("RECENT_DRAWING_TEMPLATE_IMPORT_LOCATIONS");
        Deque<String> recentImportPaths = Preferences.decodePaths(recentPathsPref);
        ISessionContext ctx = Simantics.getSessionContext();
        if (ctx == null) {
            return false;
        }
        IProject project = (IProject)ctx.getHint(ProjectKeys.KEY_PROJECT);
        if (project == null) {
            return false;
        }
        this.importModel = new ImportPlan(ctx, recentImportPaths);
        this.importModel.project = project;
        this.importModel.selection = selection.getFirstElement();
        return true;
    }

    private void writePreferences() throws IOException {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.template2d.ui");
        store.putValue("RECENT_DRAWING_TEMPLATE_IMPORT_LOCATIONS", Preferences.encodePaths(this.importModel.recentLocations));
        if (store.needsSaving()) {
            store.save();
        }
    }

    public DrawingTemplateImportWizard() {
        this.setWindowTitle("Import Diagram Template");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.readPreferences(selection);
    }

    public void addPages() {
        super.addPages();
        if (this.importModel != null) {
            this.addPage((IWizardPage)new DrawingTemplateImportPage(this.importModel));
        } else {
            this.addPage((IWizardPage)new NoProjectPage("Import Diagram Template"));
        }
    }

    public boolean performFinish() {
        try {
            this.importModel.recentLocations.addFirst(this.importModel.importLocation.getAbsolutePath());
            Preferences.removeDuplicates(this.importModel.recentLocations);
            if (this.importModel.recentLocations.size() > 10) {
                this.importModel.recentLocations.pollLast();
            }
            this.writePreferences();
        }
        catch (IOException e) {
            ErrorLogger.defaultLogError((String)"Failed to write preferences", (Throwable)e);
        }
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        Resource target = ResourceAdaptionUtils.toSingleResource((Object)DrawingTemplateImportWizard.this.importModel.selection);
                        DiagramTemplates.importTemplate((IProgressMonitor)monitor, (Session)DrawingTemplateImportWizard.this.importModel.sessionContext.getSession(), (File)DrawingTemplateImportWizard.this.importModel.importLocation, (Resource)target);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            if (t instanceof IOException) {
                cp.setErrorMessage("An I/O problem occurred while importing a diagram template.\n\nMessage: " + e.getMessage());
            }
            ErrorLogger.defaultLogError((Throwable)t);
            return false;
        }
        catch (InterruptedException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
            return false;
        }
        return true;
    }
}

