/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.simantics.Simantics;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.CopyHandler;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsClipboardBuilder;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.request.Read;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.modeling.template2d.ui.wizard.ExportPlan;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.dialogs.ShowMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrawingTemplateExporter
implements IRunnableWithProgress {
    private static final Logger LOGGER = LoggerFactory.getLogger(DrawingTemplateExporter.class);
    ExportPlan exportModel;

    public DrawingTemplateExporter(ExportPlan exportModel) {
        this.exportModel = exportModel;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
        try {
            try {
                this.exportModel(progress.newChild(50, 0));
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            catch (DatabaseException e) {
                throw new InvocationTargetException(e);
            }
            catch (BindingException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    void exportModel(SubMonitor mon) throws IOException, DatabaseException, SerializationException, BindingException {
        DrawingTemplateExporter.doExport((IProgressMonitor)mon, this.exportModel.exportLocation, this.exportModel.model.getResource());
        mon.setWorkRemaining(0);
    }

    public static void doExport(File location, Resource template) throws DatabaseException, IOException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        DrawingTemplateExporter.doExport((IProgressMonitor)monitor, location, template);
    }

    public static void doExport(final IProgressMonitor mon, File location, final Resource template) throws DatabaseException, IOException {
        try {
            mon.beginTask("Exporting diagram template...", 100);
            Session session = Simantics.getSession();
            SimanticsClipboard clipboard = (SimanticsClipboard)session.syncRequest((Read)new Read<SimanticsClipboard>(){

                public SimanticsClipboard perform(ReadGraph graph) throws DatabaseException {
                    CopyHandler ch = (CopyHandler)graph.adapt(template, CopyHandler.class);
                    SimanticsClipboardImpl clipboard = new SimanticsClipboardImpl();
                    ch.copyToClipboard(graph, (SimanticsClipboardBuilder)clipboard, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)mon, (int)50));
                    return clipboard;
                }
            });
            for (Set object : clipboard.getContents()) {
                TransferableGraph1 tg = (TransferableGraph1)ClipboardUtils.accept((Set)object, (IHintContext.Key)SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
                mon.worked(50);
                mon.setTaskName("Writing transferable graph...");
                DataContainers.writeFile((File)location, (DataContainer)new DataContainer("drawingTemplate", 2, new Variant(TransferableGraph1.BINDING, (Object)tg)));
                mon.worked(5);
            }
        }
        catch (DatabaseException e) {
            LOGGER.error("Drawing template export failed", (Throwable)e);
            mon.setCanceled(true);
            ShowMessage.showError((String)"Export failed.", (String)"Internal application error in export. See log for details.");
        }
    }
}

