/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.actions;

import java.awt.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Write;
import org.simantics.diagram.G2DUtils;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.modeling.template2d.ontology.Template2dResource;

public class SetBorderColor
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource parent = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (win == null) {
                    return;
                }
                Shell shell = win.getShell();
                if (shell == null) {
                    return;
                }
                ColorDialog dia = new ColorDialog(shell);
                final RGB rgb = dia.open();
                if (rgb == null) {
                    return;
                }
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph g) throws DatabaseException {
                        g.markUndoPoint();
                        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)g);
                        G2DResource G2D = G2DResource.getInstance((ReadGraph)g);
                        if (!g.isInstanceOf(parent, TEMPLATE2D.Border)) {
                            return;
                        }
                        Resource oldColor = g.getPossibleObject(parent, G2D.HasColor);
                        Resource color = G2DUtils.createColor((WriteGraph)g, (Color)new Color(rgb.red, rgb.green, rgb.blue));
                        if (oldColor != null) {
                            g.deny(oldColor);
                        }
                        g.claim(parent, G2D.HasColor, color);
                    }
                });
            }
        };
    }
}

