package org.simantics.modeling.adapters;

import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;

public class SCLTest implements Test {

    private Resource rule;
    
    public SCLTest(ReadGraph graph, Resource rule) {
        this.rule = rule;
    }
    
    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class) || contentType.equals(Variable.class);
    }

    @Override
    public boolean test(ReadGraph graph, Object content) throws DatabaseException {
    	
        ModelingResources MOD = ModelingResources.getInstance(graph);
        
        Variable ruleVariable = Variables.getVariable(graph, rule);
        Function1<Object,Boolean> test = ruleVariable.getPossiblePropertyValue(graph, MOD.SCLTest_test);
        if(test == null) return false;

        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get("graph");
        try {
            sclContext.put("graph", graph);
            Object value = test.apply((Resource)content);
            return (Boolean)value;
        } catch (Throwable t) {
        	throw new DatabaseException(t);
        } finally {
            sclContext.put("graph", oldGraph);
        }
    	
    }

}
