package org.simantics.modeling;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;

public class GetSymbolGroups {

    public static Collection<Resource> getSymbolGroups(ReadGraph graph, Resource model) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        DiagramResource DIA = DiagramResource.getInstance(graph);
        Collection<Resource> results = graph.syncRequest(new ObjectsWithType(model, L0.ConsistsOf, DIA.SymbolReferenceLibrary));
        return results;
    }
}
