package org.simantics.modeling;

import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.procedure.Listener;
import org.simantics.scl.compiler.environment.specification.EnvironmentSpecification;
import org.simantics.scl.compiler.module.repository.ImportFailureException;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;

public class ComponentTypeScriptRuntimeEnvironmentRequest extends ParametrizedPrimitiveRead<EnvironmentSpecification, RuntimeEnvironment> {
    UpdateListener listener;
    
    public ComponentTypeScriptRuntimeEnvironmentRequest(EnvironmentSpecification parameter) {
        super(parameter);
    }

    @Override
    public void register(ReadGraph graph, Listener<RuntimeEnvironment> procedure) {
        if(!procedure.isDisposed() && listener == null) {
            listener = new UpdateListener() {
                @Override
                public void notifyAboutUpdate() {
                    createRuntimeEnvironment(graph, procedure, this);
                }
            };
        }
        createRuntimeEnvironment(graph, procedure, listener);
    }

    @Override
    public void unregistered() {
        if(listener != null)
            listener.stopListening();
    }
    
    private void createRuntimeEnvironment(ReadGraph graph, Listener<RuntimeEnvironment> procedure, UpdateListener listener) {
        SCLContext context = SCLContext.getCurrent();
        Object oldGraph = context.put("graph", graph);
        try {
            procedure.execute(SCLOsgi.MODULE_REPOSITORY.createRuntimeEnvironment(parameter, ComponentTypeScriptRuntimeEnvironmentRequest.class.getClassLoader(), listener));
        }
        catch (ImportFailureException e) {
            procedure.exception(e);
        }
        finally {
            context.put("graph", oldGraph);
        }
    }

}
