package org.simantics.modeling;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.simantics.scl.runtime.tuple.Tuple3;

public class ColorDescriptorUtil {
	public static ColorDescriptor colorDescriptor(Tuple3 color) {
		return ColorDescriptor.createFrom(new RGB((int)(((double)color.c0) * 255), (int)(((double)color.c1) * 255), (int)(((double)color.c2) * 255)));
	}
	
	public static Tuple3 colorDescriptorAsTuple3(ColorDescriptor descriptor) {
		Color color = ((ColorDescriptor)descriptor).createColor(Display.getDefault());
		return new Tuple3(color.getRed(), color.getGreen(), color.getBlue());
	}
	
	public synchronized static String colorDescriptorAsHex(ColorDescriptor descriptor) {
		Color color = ((ColorDescriptor)descriptor).createColor(Display.getDefault());
		return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
	}
}
