/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.message.ui;

import java.io.File;
import java.util.*;

/**
 * Manages the log file providers.
 * One adds log file provider to let Log View know where to find log files.
 */
public class LogFilesManager {

	private static List<ILogFileProvider> logFileProviders = new ArrayList<ILogFileProvider>();

	/**
	 * Adds log file provider.
	 * Has no effect if an identical provider is already registered. 
	 */
	public static void addLogFileProvider(ILogFileProvider provider) {
		if (!logFileProviders.contains(provider)) {
			logFileProviders.add(provider);
		}
	}

	/**
	 * Removes log file provider.
	 * Has no effect if an identical provider is already removed.
	 */
	public static void removeLogFileProvider(ILogFileProvider provider) {
		logFileProviders.remove(provider);
	}

	/**
	 * Returns the list of logs.
	 */
    static Map<String, File> getLogSources() {
		ILogFileProvider[] providers = (ILogFileProvider[]) logFileProviders.toArray(new ILogFileProvider[logFileProviders.size()]);
		Map<String, File> result = new HashMap<String, File>();

		for (int i = 0; i < providers.length; i++) {
			ILogFileProvider provider = providers[i];

			Map<String, File> sources = provider.getLogSources();
			result.putAll(sources);
		}

		return result;
	}
}
