/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.message.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.simantics.message.IMessageDataSchemeExtension;
import org.simantics.message.IMessageSchemeHandler;
import org.simantics.message.IReferenceSerializer;

/**
 * @author Tuukka Lehtonen
 */
public class MessageDataSchemeExtension implements IMessageDataSchemeExtension {

    private final IConfigurationElement schemeElement;
    private final String                id;
    private final String                scheme;
    private final String                description;
    private IConfigurationElement       handlerElement;

    public MessageDataSchemeExtension(IConfigurationElement el, String id, String scheme, String description) {
        this.schemeElement = el;
        this.id = id;
        this.scheme = scheme;
        this.description = description;
    }

    public IConfigurationElement getSchemeElement() {
        return schemeElement;
    }

    public IConfigurationElement getHandlerElement() {
        return handlerElement;
    }

    public void setHandlerElement(IConfigurationElement handlerElement) {
        this.handlerElement = handlerElement;
    }

    /* (non-Javadoc)
     * @see org.simantics.message.IMessageDataSchemeExtension#getId()
     */
    public String getId() {
        return id;
    }

    /* (non-Javadoc)
     * @see org.simantics.message.IMessageDataSchemeExtension#getScheme()
     */
    public String getScheme() {
        return scheme;
    }

    /* (non-Javadoc)
     * @see org.simantics.message.IMessageDataSchemeExtension#getDescription()
     */
    public String getDescription() {
        return description;
    }

    /* (non-Javadoc)
     * @see org.simantics.message.IMessageDataSchemeExtension#getHandler()
     */
    public IMessageSchemeHandler getHandler() {
        if (handlerElement == null)
            return null;

        try {
            return (IMessageSchemeHandler) handlerElement.createExecutableExtension("handler");
        } catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    /* (non-Javadoc)
     * @see org.simantics.message.IMessageDataSchemeExtension#getSerializer()
     */
    public IReferenceSerializer getSerializer() {
        try {
            return (IReferenceSerializer) schemeElement.createExecutableExtension("serializer");
        } catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

}