/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.constraint.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.mapping.IContextualModification;
import org.simantics.mapping.constraint.instructions.IInstruction;

public class ExistsInstruction
implements IInstruction {
    IInstruction instruction;
    int[] variables;

    public ExistsInstruction(IInstruction instruction, int ... variables) {
        this.instruction = instruction;
        this.variables = variables;
    }

    @Override
    public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
        this.instruction.collectVariables(reads, writes);
    }

    @Override
    public IContextualModification claim(ReadGraph g, Object[] bindings) throws DatabaseException {
        if (this.instruction.query(g, bindings) == IInstruction.FAILURE) {
            return new Claim();
        }
        return null;
    }

    @Override
    public IContextualModification deny(ReadGraph g, Object[] bindings) throws DatabaseException {
        Object continuation = this.instruction.query(g, bindings);
        if (continuation != IInstruction.FAILURE) {
            return new Deny(continuation);
        }
        return null;
    }

    @Override
    public void doClaim(WriteGraph g, Object[] bindings) throws DatabaseException {
        if (this.instruction.query((ReadGraph)g, bindings) == IInstruction.FAILURE) {
            int[] nArray = this.variables;
            int n = this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                int var = nArray[n2];
                bindings[var] = g.newResource();
                ++n2;
            }
            this.instruction.doClaim(g, bindings);
        }
    }

    @Override
    public void doDeny(WriteGraph g, Object[] bindings) throws DatabaseException {
        Object continuation = this.instruction.query((ReadGraph)g, bindings);
        if (continuation != IInstruction.FAILURE) {
            do {
                int[] nArray = this.variables;
                int n = this.variables.length;
                int n2 = 0;
                while (n2 < n) {
                    int var = nArray[n2];
                    RemoverUtil.remove((WriteGraph)g, (Resource)((Resource)bindings[var]));
                    ++n2;
                }
            } while ((continuation = this.instruction.next((ReadGraph)g, bindings, continuation)) != null && continuation != IInstruction.FAILURE);
        }
    }

    @Override
    public void mapVariables(TIntIntHashMap map) {
        this.instruction.mapVariables(map);
        int i = 0;
        while (i < this.variables.length) {
            this.variables[i] = map.get(this.variables[i]);
            ++i;
        }
    }

    @Override
    public Object next(ReadGraph g, Object[] bindings, Object continuation) throws DatabaseException {
        return this.instruction.next(g, bindings, continuation);
    }

    @Override
    public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
        return this.instruction.query(g, bindings);
    }

    @Override
    public void toString(StringBuilder b, int indent) {
        b.append('[');
        boolean first = true;
        int[] nArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            if (first) {
                first = false;
            } else {
                b.append(',');
            }
            b.append(v);
            ++n2;
        }
        b.append("] ");
        this.instruction.toString(b, indent + 1);
    }

    class Claim
    implements IContextualModification {
        @Override
        public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
            int[] nArray = ExistsInstruction.this.variables;
            int n = ExistsInstruction.this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                int var = nArray[n2];
                bindings[var] = g.newResource();
                ++n2;
            }
            ExistsInstruction.this.instruction.doClaim(g, bindings);
        }
    }

    class Deny
    implements IContextualModification {
        Object continuation;

        public Deny(Object continuation) {
            this.continuation = continuation;
        }

        @Override
        public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
            Object continuation = this.continuation;
            do {
                int[] nArray = ExistsInstruction.this.variables;
                int n = ExistsInstruction.this.variables.length;
                int n2 = 0;
                while (n2 < n) {
                    int var = nArray[n2];
                    RemoverUtil.remove((WriteGraph)g, (Resource)((Resource)bindings[var]));
                    ++n2;
                }
            } while ((continuation = ExistsInstruction.this.instruction.next((ReadGraph)g, bindings, continuation)) != null && continuation != IInstruction.FAILURE);
        }
    }
}

