/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.pattern;


public class MappingRule {
	/*
	static final THashSet<Resource> EMPTY_SET = new THashSet<Resource>();
	
	THashMap<Resource, Resource> resourcesByDomains = new THashMap<Resource, Resource>();
	Collection<IConstraint> constraints = new ArrayList<IConstraint>();
	Collection<ConstraintGroup> constraintGroups = new ArrayList<ConstraintGroup>();
	
	static class ConstraintGroup {
		Collection<IConstraint> constraints;
		Collection<Resource> targets;
		Collection<Resource> dependencies;
	}
	
	class DirectedRuleBuilder {
		THashSet<Resource> sourceResources = new THashSet<Resource>();
		THashSet<Resource> targetResources = new THashSet<Resource>();
		THashSet<IConstraint> sourceConstraints = new THashSet<IConstraint>();
		THashSet<IConstraint> targetConstraints = new THashSet<IConstraint>();
		TObjectIntHashMap<Resource> boundResources;
		int id;
		
		Instruction root = new DummyInstruction();
		Instruction cur = root;
		
		public DirectedRuleBuilder(final THashSet<Resource> sourceDomains,
				TObjectIntHashMap<Resource> boundResources, int id) {
			this.boundResources = boundResources;
			this.id = id;
			
			// Classify resources
			
			resourcesByDomains.forEachEntry(new TObjectObjectProcedure<Resource, Resource>() {

				@Override
				public boolean execute(Resource domain, Resource resource) {
					if(sourceDomains.contains(domain))
						sourceResources.add(resource);
					else
						targetResources.add(resource);
					return true;
				}
				
			});
			
			// Classify constraints			
			
			for(IConstraint constraint : constraints) {
				if(sourceResources.containsAll(constraint.binds()))
					sourceConstraints.add(constraint);
				else
					targetConstraints.add(constraint);
			}
		}	
		
		int bestValue;
		IConstraint bestConstraint;
		
		private void findBestConstraint(THashSet<IConstraint> constraints) {
			bestValue = 0;
			bestConstraint = null;
			sourceConstraints.forEach(new TObjectProcedure<IConstraint>() {
				
				@Override
				public boolean execute(IConstraint constraint) {
					int temp = constraint.isApplicable(boundResources);
					if(temp>bestValue) {
						bestValue = temp;
						bestConstraint = constraint;
					}
					return true;
				}
				
			});
		}
		
		private void applyConstraint(THashSet<Resource> resources, IConstraint constraint) {
			THashSet<Resource> unbounded = new THashSet<Resource>();
			for(Resource r : constraint.binds())
				if(resources.remove(r)) {
					unbounded.add(r);
					boundResources.put(r, id++);
				}					
			Instruction temp = constraint.createQueryInstruction(boundResources, unbounded);
			cur.next = temp;
			cur = temp;			
		}
		
		private void applyConstraints(THashSet<Resource> resources, THashSet<IConstraint> constraints) {
			while(!constraints.isEmpty()) {
				findBestConstraint(constraints);				
				if(bestConstraint != null) {
					applyConstraint(resources, bestConstraint);
					constraints.remove(bestConstraint);
				}
				else
					throw new RuntimeException("Cannot form a directed mapping.");
			}
		}
		
		public void orderSourceConstraints() {
			applyConstraints(sourceResources, sourceConstraints);
			if(!sourceResources.isEmpty())
				throw new RuntimeException("Couldn't bind all source resources");
		}
		
		public void orderTargetConstraints() {
			THashSet<ConstraintGroup> groups = new THashSet<ConstraintGroup>(constraintGroups);
			while(!groups.isEmpty()) {
				
				// Find a suitable group
				
				final Ref<ConstraintGroup> possibleGroup = new Ref<ConstraintGroup>();
				final Collection<ConstraintGroup> removableGroups = new ArrayList<ConstraintGroup>();
				groups.forEach(new TObjectProcedure<ConstraintGroup>() {

					@Override
					public boolean execute(ConstraintGroup group) {
						for(Resource target : group.targets)
							if(boundResources.containsKey(target)) {
								removableGroups.add(group);
								return true;
							}
						for(Resource dep : group.dependencies)
							if(!boundResources.containsKey(dep))
								return true;
						possibleGroup.value = group;
						return false;
					}
					
				});
				groups.removeAll(removableGroups);
				if(possibleGroup.value == null) {
					if(!groups.isEmpty())
						throw new RuntimeException("Couldn't find a suitable group.");
					break;
				}
				groups.remove(possibleGroup.value);
				ConstraintGroup group = possibleGroup.value;
					
				// Order group constraints
				
				THashSet<IConstraint> groupConstraints = new THashSet<IConstraint>();
				for(IConstraint constraint : group.constraints)
					if(targetConstraints.remove(constraint))
						groupConstraints.add(constraint);
				
				applyConstraints(targetResources, groupConstraints);
				
				// Apply other constraints
				
				final Collection<IConstraint> removableConstraints = new ArrayList<IConstraint>();
				targetConstraints.forEach(new TObjectProcedure<IConstraint>() {

					@Override
					public boolean execute(IConstraint constraint) {
						for(Resource r : constraint.binds())
							if(!boundResources.containsKey(r))
								return true;
						
						Instruction temp = constraint.createQueryInstruction(boundResources, EMPTY_SET);
						cur.next = temp;
						cur = temp;
						
						removableConstraints.add(constraint);
						return true;
					}
					
				});
				targetConstraints.removeAll(removableConstraints);
			}
			if(!targetResources.isEmpty())
				throw new RuntimeException("Couldn't bind all target resources");
		}
		
	}
	*/
}
