/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.constraint.instructions;

import gnu.trove.set.hash.TIntHashSet;

import java.util.Collection;
import java.util.Iterator;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class TripletPredicateObjectQuery extends TripletInstruction {

	Resource predicate;
	
	public TripletPredicateObjectQuery(int variable0, int variable1, int variable2,
			Resource predicate) {
		super(variable0, variable1, variable2);
		this.predicate = predicate;
	}
	
	public TripletPredicateObjectQuery(int variable0, int variable1, int variable2) {
		this(variable0, variable1, variable2, null);
	}
	
	@Override
	public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
		Resource r0 = (Resource)bindings[variable0];
//		ITask task = ThreadLogger.getInstance().begin("g");
		Collection<Statement> result =
			predicate == null 
			? g.getStatements(r0, Layer0.getInstance(g).IsWeaklyRelatedTo)
				: g.getStatements(r0, predicate);
//		task.finish();
		if(result.isEmpty())
			return IInstruction.FAILURE;
		Iterator<Statement> it = result.iterator();
		Statement stat = it.next();
		bindings[variable1] = stat.getPredicate();
		bindings[variable2] = stat.getObject();
		if(it.hasNext())
			return it;
		else
			return null;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public Object next(ReadGraph g, Object[] bindings, Object continuation) {
		Iterator<Statement> it = (Iterator<Statement>)continuation;
		if(it.hasNext()) {
			Statement stat = it.next();
			bindings[variable1] = stat.getPredicate();
			bindings[variable2] = stat.getObject();
			if(it.hasNext())
				return it;
			else
				return null;
		}
		else
			return IInstruction.FAILURE;
	}	
	
	@Override
	public void collectVariables(TIntHashSet reads, TIntHashSet writes) {		
		super.collectVariables(reads, writes);
		writes.add(variable1);
		writes.add(variable2);
	}

}
